/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.AnalyticHestonEngine_Integration;
import org.quantlib.DoublePair;
import org.quantlib.HestonModel;
import org.quantlib.PricingEngine;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class AnalyticHestonEngine
extends PricingEngine
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected AnalyticHestonEngine(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.AnalyticHestonEngine_SWIGSmartPtrUpcast(cPtr), true);
        this.swigCMemOwnDerived = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AnalyticHestonEngine obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwnDerived = own;
        super.swigSetCMemOwn(own);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                QuantLibJNI.delete_AnalyticHestonEngine(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public AnalyticHestonEngine(HestonModel model, long integrationOrder) {
        this(QuantLibJNI.new_AnalyticHestonEngine__SWIG_0(HestonModel.getCPtr(model), model, integrationOrder), true);
    }

    public AnalyticHestonEngine(HestonModel model) {
        this(QuantLibJNI.new_AnalyticHestonEngine__SWIG_1(HestonModel.getCPtr(model), model), true);
    }

    public AnalyticHestonEngine(HestonModel model, double relTolerance, long maxEvaluations) {
        this(QuantLibJNI.new_AnalyticHestonEngine__SWIG_2(HestonModel.getCPtr(model), model, relTolerance, maxEvaluations), true);
    }

    public AnalyticHestonEngine(HestonModel model, ComplexLogFormula cpxLog, AnalyticHestonEngine_Integration itg, double andersenPiterbargEpsilon) {
        this(QuantLibJNI.new_AnalyticHestonEngine__SWIG_3(HestonModel.getCPtr(model), model, cpxLog.swigValue(), AnalyticHestonEngine_Integration.getCPtr(itg), itg, andersenPiterbargEpsilon), true);
    }

    public AnalyticHestonEngine(HestonModel model, ComplexLogFormula cpxLog, AnalyticHestonEngine_Integration itg) {
        this(QuantLibJNI.new_AnalyticHestonEngine__SWIG_4(HestonModel.getCPtr(model), model, cpxLog.swigValue(), AnalyticHestonEngine_Integration.getCPtr(itg), itg), true);
    }

    public long numberOfEvaluations() {
        return QuantLibJNI.AnalyticHestonEngine_numberOfEvaluations(this.swigCPtr, this);
    }

    public DoublePair chF(double real, double imag, double t) {
        return new DoublePair(QuantLibJNI.AnalyticHestonEngine_chF(this.swigCPtr, this, real, imag, t), true);
    }

    public static final class ComplexLogFormula {
        public static final ComplexLogFormula Gatheral = new ComplexLogFormula("Gatheral");
        public static final ComplexLogFormula BranchCorrection = new ComplexLogFormula("BranchCorrection");
        public static final ComplexLogFormula AndersenPiterbarg = new ComplexLogFormula("AndersenPiterbarg");
        public static final ComplexLogFormula AndersenPiterbargOptCV = new ComplexLogFormula("AndersenPiterbargOptCV");
        public static final ComplexLogFormula AsymptoticChF = new ComplexLogFormula("AsymptoticChF");
        public static final ComplexLogFormula AngledContour = new ComplexLogFormula("AngledContour");
        public static final ComplexLogFormula AngledContourNoCV = new ComplexLogFormula("AngledContourNoCV");
        public static final ComplexLogFormula OptimalCV = new ComplexLogFormula("OptimalCV");
        private static ComplexLogFormula[] swigValues = new ComplexLogFormula[]{Gatheral, BranchCorrection, AndersenPiterbarg, AndersenPiterbargOptCV, AsymptoticChF, AngledContour, AngledContourNoCV, OptimalCV};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static ComplexLogFormula swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && ComplexLogFormula.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (ComplexLogFormula.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(ComplexLogFormula.class) + " with value " + swigValue);
        }

        private ComplexLogFormula(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private ComplexLogFormula(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private ComplexLogFormula(String swigName, ComplexLogFormula swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

