/*
 * Decompiled with CFR 0.152.
 */
package io.eblock.eos4j.api.utils;

import io.eblock.eos4j.api.exception.ApiError;
import io.eblock.eos4j.api.exception.ApiException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class Generator {
    private static OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
    private static Retrofit.Builder builder = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create());
    private static Retrofit retrofit;

    public static <S> S createService(Class<S> serviceClass, String baseUrl) {
        builder.baseUrl(baseUrl);
        builder.client(httpClient.build());
        builder.addConverterFactory((Converter.Factory)JacksonConverterFactory.create());
        retrofit = builder.build();
        return (S)retrofit.create(serviceClass);
    }

    public static <T> T executeSync(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            ApiError apiError = Generator.getApiError(response);
            throw new ApiException(apiError);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private static ApiError getApiError(Response<?> response) throws IOException, ApiException {
        return (ApiError)retrofit.responseBodyConverter(ApiError.class, new Annotation[0]).convert((Object)response.errorBody());
    }
}

