/*
 * Decompiled with CFR 0.152.
 */
package io.eblock.eos4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.eblock.eos4j.Ecc;
import io.eblock.eos4j.api.vo.SignParam;
import io.eblock.eos4j.api.vo.transaction.push.Tx;
import io.eblock.eos4j.api.vo.transaction.push.TxAction;
import io.eblock.eos4j.api.vo.transaction.push.TxRequest;
import io.eblock.eos4j.api.vo.transaction.push.TxSign;
import io.eblock.eos4j.ese.Action;
import io.eblock.eos4j.ese.DataParam;
import io.eblock.eos4j.ese.DataType;
import io.eblock.eos4j.ese.Ese;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.TimeZone;

public class OfflineSign {
    SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public OfflineSign() {
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String pushTransaction(String compression, Tx pushTransaction, String[] signatures) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String mapJakcson = mapper.writeValueAsString((Object)new TxRequest(compression, pushTransaction, signatures));
        return mapJakcson;
    }

    public String transfer(SignParam signParam, String pk, String contractAccount, String from, String to, String quantity, String memo) throws Exception {
        Tx tx = new Tx();
        tx.setExpiration(signParam.getHeadBlockTime().getTime() / 1000L + signParam.getExp());
        tx.setRef_block_num(signParam.getLastIrreversibleBlockNum());
        tx.setRef_block_prefix(signParam.getRefBlockPrefix());
        tx.setNet_usage_words(0L);
        tx.setMax_cpu_usage_ms(0L);
        tx.setDelay_sec(0L);
        ArrayList<TxAction> actions = new ArrayList<TxAction>();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("from", from);
        dataMap.put("to", to);
        dataMap.put("quantity", new DataParam(quantity, DataType.asset, Action.transfer).getValue());
        dataMap.put("memo", memo);
        TxAction action = new TxAction(from, contractAccount, "transfer", dataMap);
        actions.add(action);
        tx.setActions(actions);
        String sign = Ecc.signTransaction(pk, new TxSign(signParam.getChainId(), tx));
        String data = Ecc.parseTransferData(from, to, quantity, memo);
        action.setData(data);
        tx.setExpiration(this.dateFormatter.format(new Date(1000L * Long.parseLong(tx.getExpiration().toString()))));
        return this.pushTransaction("none", tx, new String[]{sign});
    }

    public String createAccount(SignParam signParam, String pk, String creator, String newAccount, String owner, String active, Long buyRam) throws Exception {
        Tx tx = new Tx();
        tx.setExpiration(signParam.getHeadBlockTime().getTime() / 1000L + signParam.getExp());
        tx.setRef_block_num(signParam.getLastIrreversibleBlockNum());
        tx.setRef_block_prefix(signParam.getRefBlockPrefix());
        tx.setNet_usage_words(0L);
        tx.setMax_cpu_usage_ms(0L);
        tx.setDelay_sec(0L);
        ArrayList<TxAction> actions = new ArrayList<TxAction>();
        tx.setActions(actions);
        LinkedHashMap<String, String> createMap = new LinkedHashMap<String, String>();
        createMap.put("creator", creator);
        createMap.put("name", newAccount);
        createMap.put("owner", owner);
        createMap.put("active", active);
        TxAction createAction = new TxAction(creator, "eosio", "newaccount", createMap);
        actions.add(createAction);
        LinkedHashMap<String, Object> buyMap = new LinkedHashMap<String, Object>();
        buyMap.put("payer", creator);
        buyMap.put("receiver", newAccount);
        buyMap.put("bytes", buyRam);
        TxAction buyAction = new TxAction(creator, "eosio", "buyrambytes", buyMap);
        actions.add(buyAction);
        String sign = Ecc.signTransaction(pk, new TxSign(signParam.getChainId(), tx));
        String accountData = Ese.parseAccountData(creator, newAccount, owner, active);
        createAction.setData(accountData);
        String ramData = Ese.parseBuyRamData(creator, newAccount, buyRam);
        buyAction.setData(ramData);
        tx.setExpiration(this.dateFormatter.format(new Date(1000L * Long.parseLong(tx.getExpiration().toString()))));
        return this.pushTransaction("none", tx, new String[]{sign});
    }
}

