/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.maven.shacl;

import io.github.qudtlib.maven.shacl.AbstractShacMojo;
import io.github.qudtlib.maven.shacl.DataAndShapes;
import io.github.qudtlib.maven.shacl.ShaclResultSeverity;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.validation.Severity;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.topbraid.shacl.validation.ValidationEngineConfiguration;
import org.topbraid.shacl.validation.ValidationUtil;

@Mojo(name="validate", defaultPhase=LifecyclePhase.TEST)
public class ShaclValidationMojo
extends AbstractShacMojo {
    @Parameter(required=true)
    private List<DataAndShapes> validations;
    @Parameter(defaultValue="Violation")
    private ShaclResultSeverity failOnSeverity;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Running SHACL Validations");
        for (DataAndShapes validation : this.validations) {
            try {
                this.performShaclValidation(validation);
            }
            catch (FileNotFoundException e) {
                throw new MojoFailureException("Error performing SHACL validation", (Throwable)e);
            }
        }
    }

    private void performShaclValidation(DataAndShapes dataAndShapes) throws MojoFailureException, FileNotFoundException {
        this.getLog().info((CharSequence)"SHACL Validation config ");
        CharSequence[] shapesFiles = this.getFilesForPatterns(dataAndShapes.getShapes());
        CharSequence[] dataFiles = this.getFilesForPatterns(dataAndShapes.getData());
        this.getLog().info((CharSequence)("shapes: " + String.join((CharSequence)", ", shapesFiles)));
        this.getLog().info((CharSequence)("data: " + String.join((CharSequence)", ", dataFiles)));
        if (dataAndShapes.isSkip()) {
            this.getLog().info((CharSequence)"Validation skipped");
            return;
        }
        this.debug("Loading SHACL shapes", new Object[0]);
        Graph shapesGraph = this.loadRdf((String[])shapesFiles);
        Model shapes = ModelFactory.createModelForGraph((Graph)shapesGraph);
        this.debug("Loading data to validate", new Object[0]);
        Graph dataGraph = this.loadRdf((String[])dataFiles);
        Model data = ModelFactory.createModelForGraph((Graph)dataGraph);
        Resource validationReport = ValidationUtil.validateModel((Model)data, (Model)shapes, (ValidationEngineConfiguration)new ValidationEngineConfiguration().setReportDetails(true).setValidateShapes(false));
        Model model = validationReport.getModel();
        this.writeModelToFile(dataAndShapes.getOutputFile(), model, "The validation report was written to %s");
        ValidationReport jenaValidationReport = ValidationReport.fromModel((Model)validationReport.getModel());
        this.getLog().info((CharSequence)String.format("%d reports found. Severities:", this.countReports(jenaValidationReport, new Severity[0])));
        this.getLog().info((CharSequence)String.format("\tsh:Violoation: %d", this.countReports(jenaValidationReport, Severity.Violation)));
        this.getLog().info((CharSequence)String.format("\tsh:Warning   : %d", this.countReports(jenaValidationReport, Severity.Warning)));
        this.getLog().info((CharSequence)String.format("\tsh:Info      : %d", this.countReports(jenaValidationReport, Severity.Info)));
        boolean buildFails = this.isBuildFails(jenaValidationReport);
        this.getLog().info((CharSequence)String.format("The threshold for failing the build is '%s', therefore, the build %s.", new Object[]{this.failOnSeverity, buildFails ? "fails" : "succeeds"}));
        this.getLog().info((CharSequence)"To change this behaviour, use the plugin's 'failOnSeverity' parameter (default: 'Violation', other options: 'Warning', 'Info')");
        if (buildFails) {
            ShLib.printReport((Resource)validationReport);
            throw new MojoFailureException(String.format("SHACL validation failed.\nShapes files: %s\nData files:%s", Arrays.stream(shapesFiles).collect(Collectors.joining("\n\t", "\n\t", "\n")), Arrays.stream(dataFiles).collect(Collectors.joining("\n\t", "\n\t", "\n"))));
        }
    }

    private boolean isBuildFails(ValidationReport validationReport) {
        if (this.failOnSeverity == ShaclResultSeverity.Info) {
            return validationReport.conforms();
        }
        if (this.failOnSeverity == ShaclResultSeverity.Warning) {
            return this.countReports(validationReport, Severity.Warning, Severity.Violation) > 0L;
        }
        if (this.failOnSeverity == ShaclResultSeverity.Violation) {
            return this.countReports(validationReport, Severity.Violation) > 0L;
        }
        throw new IllegalStateException(String.format("Cannot handle value '%s' of parameter'%s'", new Object[]{this.failOnSeverity, "'failOnSeverity'"}));
    }

    private long countReports(ValidationReport validationReport, Severity ... severities) {
        return validationReport.getEntries().stream().filter(e -> Arrays.stream(severities).anyMatch(s -> e.severity() == s)).count();
    }
}

