/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.maven.shacl;

import io.github.qudtlib.maven.shacl.AbstractShacMojo;
import io.github.qudtlib.maven.shacl.DataAndShapes;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.topbraid.jenax.progress.NullProgressMonitor;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.shacl.rules.RuleUtil;
import org.topbraid.shacl.vocabulary.SH;

@Mojo(name="infer", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ShaclInferenceMojo
extends AbstractShacMojo {
    @Parameter(required=true)
    private List<DataAndShapes> inferences;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Running SHACL Inferences");
        for (DataAndShapes check : this.inferences) {
            try {
                this.performShaclInference(check);
            }
            catch (FileNotFoundException e) {
                throw new MojoFailureException("Error performing SHACL validation", (Throwable)e);
            }
        }
    }

    private void performShaclInference(DataAndShapes dataAndShapes) throws MojoFailureException, FileNotFoundException {
        this.getLog().info((CharSequence)"SHACL Inference configuration:");
        String[] shapesFiles = this.getFilesForPatterns(dataAndShapes.getShapes());
        String[] dataFiles = this.getFilesForPatterns(dataAndShapes.getData());
        this.getLog().info((CharSequence)("\tshapes: " + Arrays.stream(shapesFiles).collect(Collectors.joining("\n\t", "\n\t", "\n"))));
        this.getLog().info((CharSequence)("\tdata: " + Arrays.stream(dataFiles).collect(Collectors.joining("\n\t", "\n\t", "\n"))));
        this.getLog().info((CharSequence)("\toutput: " + dataAndShapes.getOutputFile()));
        if (dataAndShapes.getOutputFile() == null) {
            throw new MojoFailureException("You must specify an output file for the inferred triples!");
        }
        if (dataAndShapes.isSkip()) {
            this.getLog().info((CharSequence)"Inferencing skipped");
            return;
        }
        this.debug("Loading SHACL shapes", new Object[0]);
        Graph shapesGraph = this.loadRdf(shapesFiles);
        Model shapes = ModelFactory.createModelForGraph((Graph)shapesGraph);
        this.debug("Loading data to infer from", new Object[0]);
        Graph dataGraph = this.loadRdf(dataFiles);
        Model data = ModelFactory.createModelForGraph((Graph)dataGraph);
        Model inferences = ModelFactory.createDefaultModel();
        inferences.setNsPrefixes(data.getNsPrefixMap());
        RuleUtil.executeRules((Model)data, (Model)shapes, (Model)inferences, (ProgressMonitor)new NullProgressMonitor());
        this.writeModelToFile(dataAndShapes.getOutputFile(), inferences, "The inferred triples were written to %s");
    }

    private boolean isValid(Resource validationReport) {
        return !validationReport.hasProperty(SH.result);
    }
}

