/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.maven.rdfio;

import io.github.qudtlib.maven.rdfio.filter.IncludeExcludePatterns;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.DirectoryScanner;

public abstract class AbstractRdfioMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    protected File basedir;

    static String[] splitPatterns(String patterns) {
        return (String[])Arrays.stream(patterns.split("(\\s|\n)*([,\n])(\\s|\n)*")).map(String::trim).toArray(String[]::new);
    }

    protected void writeModelToFile(String outputFile, Model model, String messageFormat) throws FileNotFoundException {
        if (outputFile != null) {
            File folder = new File(outputFile).getParentFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
            AbstractRdfioMojo.deleteCarriageReturns(model);
            RDFDataMgr.write((OutputStream)new FileOutputStream(new File(this.basedir, outputFile)), (Model)model, (Lang)RDFLanguages.resourceNameToLang((String)outputFile, (Lang)Lang.TTL));
            this.getLog().info((CharSequence)String.format(messageFormat, outputFile));
        }
    }

    private static void deleteCarriageReturns(Model model) {
        Pattern containsR = Pattern.compile("\r", 8);
        ArrayList<StatementImpl> newStatements = new ArrayList<StatementImpl>();
        StmtIterator it = model.listStatements();
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            RDFNode object = s.getObject();
            if (!object.isLiteral()) continue;
            try {
                String stringValue = object.asLiteral().getString();
                RDFDatatype rdfDatatype = object.asLiteral().getDatatype();
                Matcher m = containsR.matcher(stringValue);
                if (!m.find()) continue;
                stringValue = m.replaceAll("");
                Literal newObject = rdfDatatype == null ? ResourceFactory.createStringLiteral((String)stringValue) : ResourceFactory.createTypedLiteral((String)stringValue, (RDFDatatype)rdfDatatype);
                StatementImpl newStatement = new StatementImpl(s.getSubject(), s.getPredicate(), (RDFNode)newObject);
                newStatements.add(newStatement);
                it.remove();
            }
            catch (Node.NotLiteral notLiteral) {}
        }
        model.add(newStatements);
    }

    protected Model loadRdf(String[] files) throws MojoExecutionException {
        Model model = ModelFactory.createDefaultModel();
        for (String file : files) {
            this.debug("Loading %s", file);
            File inFile = new File(this.basedir, file);
            Lang lang = RDFLanguages.resourceNameToLang((String)inFile.getName(), (Lang)Lang.TTL);
            try {
                String content = Files.readString(inFile.toPath());
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
                RDFParser.source((InputStream)inputStream).lang(lang).parse(model.getGraph());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error parsing RDF file " + inFile.getAbsolutePath(), (Exception)e);
            }
        }
        this.debug("Loaded %d triples", model.size());
        return model;
    }

    protected void debug(String pattern, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(pattern, args));
        }
    }

    protected String[] getFilesForPatterns(IncludeExcludePatterns includeExcludePatterns) {
        String[] includes = AbstractRdfioMojo.splitPatterns(includeExcludePatterns.getInclude());
        String[] excludes = AbstractRdfioMojo.splitPatterns(includeExcludePatterns.getExclude());
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.basedir);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

