/*
 * Decompiled with CFR 0.152.
 */
package PlasticMetal.Jarvis.Collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class KeyedCollection<K, I>
implements Collection<I> {
    private final Map<K, I> delegateMap = new HashMap<K, I>();

    protected abstract K getKeyFromItem(I var1);

    public Set<K> keySet() {
        return this.delegateMap.keySet();
    }

    public Set<Map.Entry<K, I>> entrySet() {
        return this.delegateMap.entrySet();
    }

    public I getOrDefault(K key, I defaultValue) {
        return this.containsKey(key) ? this.get(key) : defaultValue;
    }

    public I get(K key) {
        return this.delegateMap.get(key);
    }

    public boolean replace(I newValue) {
        K key = this.getKeyFromItem(newValue);
        if (!this.containsKey(key)) {
            return false;
        }
        this.removeAt(key);
        this.add(newValue);
        return true;
    }

    public I putIfAbsent(I value) {
        K key = this.getKeyFromItem(value);
        I r = this.get(key);
        if (!this.containsKey(key)) {
            this.add(value);
        }
        return r;
    }

    public I removeAt(K key) {
        return this.delegateMap.remove(key);
    }

    @Override
    public int size() {
        return this.delegateMap.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.delegateMap.containsKey(this.getKeyFromItem(o));
    }

    public boolean containsKey(K key) {
        return this.delegateMap.containsKey(key);
    }

    @Override
    public Iterator<I> iterator() {
        return this.delegateMap.values().iterator();
    }

    @Override
    public void forEach(Consumer<? super I> action) {
        this.delegateMap.values().forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.delegateMap.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegateMap.values().toArray(a);
    }

    @Override
    public boolean add(I v) {
        K key = this.getKeyFromItem(v);
        if (this.delegateMap.containsKey(key)) {
            return false;
        }
        this.delegateMap.put(key, v);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        K key = this.getKeyFromItem(o);
        if (!this.delegateMap.containsKey(key)) {
            return false;
        }
        this.delegateMap.remove(key);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends I> c) {
        for (I v : c) {
            if (!this.contains(v)) continue;
            return false;
        }
        for (I v : c) {
            this.add(v);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object v : c) {
            if (!this.contains(v)) continue;
            return false;
        }
        for (Object v : c) {
            this.remove(v);
        }
        return true;
    }

    @Override
    public boolean removeIf(Predicate<? super I> filter) {
        boolean flag = false;
        for (I v : this) {
            if (!filter.test(v)) continue;
            this.remove(v);
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.removeIf((Predicate<? super I>)((Predicate<Object>)c::contains));
    }

    @Override
    public void clear() {
        this.delegateMap.clear();
    }

    @Override
    public Spliterator<I> spliterator() {
        return this.delegateMap.values().spliterator();
    }

    @Override
    public Stream<I> stream() {
        return this.delegateMap.values().stream();
    }

    @Override
    public Stream<I> parallelStream() {
        return this.delegateMap.values().parallelStream();
    }
}

