/*
 * Decompiled with CFR 0.152.
 */
package io.github.pixee.security;

public final class HtmlEncoder {
    private HtmlEncoder() {
    }

    public static String encode(String s) {
        return Escape.html(s);
    }

    private static class Escape {
        private Escape() {
        }

        private static String html(String input) {
            if (input == null) {
                return null;
            }
            int length = input.length();
            StringBuilder output = Escape.allocateStringBuilder(length);
            block16: for (int i = 0; i < length; ++i) {
                char c = input.charAt(i);
                switch (c) {
                    case '\t': {
                        output.append("&#x09;");
                        continue block16;
                    }
                    case '\n': {
                        output.append("&#x0A;");
                        continue block16;
                    }
                    case '\f': {
                        output.append("&#x0C;");
                        continue block16;
                    }
                    case '\r': {
                        output.append("&#x0D;");
                        continue block16;
                    }
                    case '\'': {
                        output.append("&#39;");
                        continue block16;
                    }
                    case '\\': {
                        output.append("&#x5C;");
                        continue block16;
                    }
                    case ' ': {
                        output.append("&#x20;");
                        continue block16;
                    }
                    case '/': {
                        output.append("&#x2F;");
                        continue block16;
                    }
                    case '\"': {
                        output.append("&quot;");
                        continue block16;
                    }
                    case '<': {
                        output.append("&lt;");
                        continue block16;
                    }
                    case '>': {
                        output.append("&gt;");
                        continue block16;
                    }
                    case '&': {
                        output.append("&amp;");
                        continue block16;
                    }
                    case '\u2028': {
                        output.append("&#x2028;");
                        continue block16;
                    }
                    case '\u2029': {
                        output.append("&#x2029;");
                        continue block16;
                    }
                    default: {
                        output.append(c);
                    }
                }
            }
            return output.toString();
        }

        private static String uriParam(String input) {
            if (input == null) {
                return null;
            }
            int length = input.length();
            StringBuilder output = Escape.allocateStringBuilder(length);
            block30: for (int i = 0; i < length; ++i) {
                char c = input.charAt(i);
                switch (c) {
                    case '\t': {
                        output.append("%09");
                        continue block30;
                    }
                    case '\n': {
                        output.append("%0A");
                        continue block30;
                    }
                    case '\f': {
                        output.append("%0C");
                        continue block30;
                    }
                    case '\r': {
                        output.append("%0D");
                        continue block30;
                    }
                    case ' ': {
                        output.append("%20");
                        continue block30;
                    }
                    case '!': {
                        output.append("%21");
                        continue block30;
                    }
                    case '\"': {
                        output.append("%22");
                        continue block30;
                    }
                    case '#': {
                        output.append("%23");
                        continue block30;
                    }
                    case '$': {
                        output.append("%24");
                        continue block30;
                    }
                    case '%': {
                        output.append("%25");
                        continue block30;
                    }
                    case '&': {
                        output.append("%26");
                        continue block30;
                    }
                    case '\'': {
                        output.append("%27");
                        continue block30;
                    }
                    case '(': {
                        output.append("%28");
                        continue block30;
                    }
                    case ')': {
                        output.append("%29");
                        continue block30;
                    }
                    case '*': {
                        output.append("%2A");
                        continue block30;
                    }
                    case '+': {
                        output.append("%2B");
                        continue block30;
                    }
                    case ',': {
                        output.append("%2C");
                        continue block30;
                    }
                    case '.': {
                        output.append("%2E");
                        continue block30;
                    }
                    case '/': {
                        output.append("%2F");
                        continue block30;
                    }
                    case ':': {
                        output.append("%3A");
                        continue block30;
                    }
                    case ';': {
                        output.append("%3B");
                        continue block30;
                    }
                    case '<': {
                        output.append("%3C");
                        continue block30;
                    }
                    case '=': {
                        output.append("%3D");
                        continue block30;
                    }
                    case '>': {
                        output.append("%3E");
                        continue block30;
                    }
                    case '?': {
                        output.append("%3F");
                        continue block30;
                    }
                    case '@': {
                        output.append("%40");
                        continue block30;
                    }
                    case '[': {
                        output.append("%5B");
                        continue block30;
                    }
                    case ']': {
                        output.append("%5D");
                        continue block30;
                    }
                    default: {
                        output.append(c);
                    }
                }
            }
            return output.toString();
        }

        private static StringBuilder allocateStringBuilder(int length) {
            int buflen = length;
            if (length * 2 > 0) {
                buflen = length * 2;
            }
            return new StringBuilder(buflen);
        }
    }
}

