/*
 * Decompiled with CFR 0.152.
 */
package io.paperdb;

import android.annotation.SuppressLint;
import android.content.Context;
import com.esotericsoftware.kryo.Serializer;
import io.paperdb.Book;
import io.paperdb.PaperDbException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Paper {
    static final String TAG = "paperdb";
    static final String DEFAULT_DB_NAME = "io.paperdb";
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context mContext;
    private static final ConcurrentHashMap<String, Book> mBookMap;
    private static final HashMap<Class, Serializer> mCustomSerializers;

    public static void init(Context context) {
        mContext = context.getApplicationContext();
    }

    public static Book book(String name) {
        if (name.equals(DEFAULT_DB_NAME)) {
            throw new PaperDbException("io.paperdb name is reserved for default library name");
        }
        return Paper.getBook(null, name);
    }

    public static Book book() {
        return Paper.getBook(null, DEFAULT_DB_NAME);
    }

    public static Book bookOn(String location, String name) {
        location = Paper.removeLastFileSeparatorIfExists(location);
        return Paper.getBook(location, name);
    }

    public static Book bookOn(String location) {
        return Paper.bookOn(location, DEFAULT_DB_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Book getBook(String location, String name) {
        if (mContext == null) {
            throw new PaperDbException("Paper.init is not called");
        }
        String key = (location == null ? "" : location) + name;
        ConcurrentHashMap<String, Book> concurrentHashMap = mBookMap;
        synchronized (concurrentHashMap) {
            Book book = mBookMap.get(key);
            if (book == null) {
                book = location == null ? new Book(mContext, name, mCustomSerializers) : new Book(location, name, mCustomSerializers);
                mBookMap.put(key, book);
            }
            return book;
        }
    }

    private static String removeLastFileSeparatorIfExists(String customLocation) {
        if (customLocation.endsWith(File.separator)) {
            customLocation = customLocation.substring(0, customLocation.length() - 1);
        }
        return customLocation;
    }

    public static <T> Book put(String key, T value) {
        return Paper.book().write(key, value);
    }

    public static <T> T get(String key) {
        return Paper.book().read(key);
    }

    public static <T> T get(String key, T defaultValue) {
        return Paper.book().read(key, defaultValue);
    }

    public static boolean exist(String key) {
        return Paper.book().contains(key);
    }

    public static void delete(String key) {
        Paper.book().delete(key);
    }

    public static void clear(Context context) {
        Paper.init(context);
        Paper.book().destroy();
    }

    public static void setLogLevel(int level) {
        for (Map.Entry<String, Book> entry : mBookMap.entrySet()) {
            entry.getValue().setLogLevel(level);
        }
    }

    public static <T> void addSerializer(Class<T> clazz, Serializer<T> serializer) {
        if (!mCustomSerializers.containsKey(clazz)) {
            mCustomSerializers.put(clazz, serializer);
        }
    }

    static {
        mBookMap = new ConcurrentHashMap();
        mCustomSerializers = new HashMap();
    }
}

