/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls.detection;

import com.linkedin.urls.detection.CharUtils;

public class InputTextReader {
    private final char[] _content;
    private int _index = 0;

    public InputTextReader(String content) {
        this._content = content.toCharArray();
    }

    public char read() {
        char chr;
        return CharUtils.isWhiteSpace(chr = this._content[this._index++]) ? (char)' ' : chr;
    }

    public String peek(int numberChars) {
        return new String(this._content, this._index, numberChars);
    }

    public char peekChar(int offset) {
        if (!this.canReadChars(offset)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._content[this._index + offset];
    }

    public boolean canReadChars(int numberChars) {
        return this._content.length >= this._index + numberChars;
    }

    public boolean eof() {
        return this._content.length <= this._index;
    }

    public int getPosition() {
        return this._index;
    }

    public void seek(int position) {
        this._index = position;
    }

    public void goBack() {
        --this._index;
    }
}

