/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls;

import com.linkedin.urls.Url;
import com.linkedin.urls.UrlPart;

public class UrlMarker {
    private String _originalUrl;
    private int _schemeIndex = -1;
    private int _usernamePasswordIndex = -1;
    private int _hostIndex = -1;
    private int _portIndex = -1;
    private int _pathIndex = -1;
    private int _queryIndex = -1;
    private int _fragmentIndex = -1;

    public Url createUrl() {
        return new Url(this);
    }

    public void setOriginalUrl(String originalUrl) {
        this._originalUrl = originalUrl;
    }

    public String getOriginalUrl() {
        return this._originalUrl;
    }

    public void setIndex(UrlPart urlPart, int index) {
        switch (urlPart) {
            case SCHEME: {
                this._schemeIndex = index;
                break;
            }
            case USERNAME_PASSWORD: {
                this._usernamePasswordIndex = index;
                break;
            }
            case HOST: {
                this._hostIndex = index;
                break;
            }
            case PORT: {
                this._portIndex = index;
                break;
            }
            case PATH: {
                this._pathIndex = index;
                break;
            }
            case QUERY: {
                this._queryIndex = index;
                break;
            }
            case FRAGMENT: {
                this._fragmentIndex = index;
                break;
            }
        }
    }

    public int indexOf(UrlPart urlPart) {
        switch (urlPart) {
            case SCHEME: {
                return this._schemeIndex;
            }
            case USERNAME_PASSWORD: {
                return this._usernamePasswordIndex;
            }
            case HOST: {
                return this._hostIndex;
            }
            case PORT: {
                return this._portIndex;
            }
            case PATH: {
                return this._pathIndex;
            }
            case QUERY: {
                return this._queryIndex;
            }
            case FRAGMENT: {
                return this._fragmentIndex;
            }
        }
        return -1;
    }

    public void unsetIndex(UrlPart urlPart) {
        this.setIndex(urlPart, -1);
    }

    protected UrlMarker setIndices(int[] indices) {
        if (indices == null || indices.length != 7) {
            throw new IllegalArgumentException("Malformed index array.");
        }
        this.setIndex(UrlPart.SCHEME, indices[0]);
        this.setIndex(UrlPart.USERNAME_PASSWORD, indices[1]);
        this.setIndex(UrlPart.HOST, indices[2]);
        this.setIndex(UrlPart.PORT, indices[3]);
        this.setIndex(UrlPart.PATH, indices[4]);
        this.setIndex(UrlPart.QUERY, indices[5]);
        this.setIndex(UrlPart.FRAGMENT, indices[6]);
        return this;
    }
}

