/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.util;

import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.reflect.FieldUtil;

public class ThrowableUtil {
    public static final String FIELD_SEPARATOR = "/^*(V)*^/";

    public static final Throwable getRootCause(Throwable e) {
        Throwable p = e.getCause();
        int k = 0;
        while (p != null && ++k < 1024) {
            e = p;
            p = e.getCause();
        }
        return e;
    }

    public static final String throwableToString(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(FIELD_SEPARATOR).append(e.getMessage());
        Throwable r = ThrowableUtil.getRootCause(e);
        if (r != e) {
            sb.append(FIELD_SEPARATOR).append(r.getClass().getName());
            sb.append(FIELD_SEPARATOR).append(r.getMessage());
        }
        sb.append(FIELD_SEPARATOR);
        StackTraceElement[] elements = r.getStackTrace();
        if (elements != null && elements.length > 0) {
            StackTraceElement el = elements[0];
            sb.append(el.getFileName()).append(":").append(el.getLineNumber());
            sb.append(" => ").append(el.getClassName()).append("#");
            sb.append(el.getMethodName()).append("(..)");
        } else {
            sb.append("NO_STACK_STRACE");
        }
        return sb.toString();
    }

    public static final Throwable strToThrowable(String s) throws Exception {
        String[] items = StringUtil.split(s, FIELD_SEPARATOR, true);
        if (items.length != 3 && items.length != 5) {
            return null;
        }
        Throwable e = (Throwable)Class.forName(items[0]).newInstance();
        FieldUtil.setValue(e, "detailMessage", items[1]);
        Throwable r = null;
        if (items.length == 5) {
            r = (Throwable)Class.forName(items[2]).newInstance();
            FieldUtil.setValue(r, "detailMessage", items[3]);
            FieldUtil.setValue(r, "cause", new Throwable(items[4]));
        } else {
            r = new Throwable(items[2]);
        }
        FieldUtil.setValue(e, "cause", r);
        return e;
    }
}

