/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import org.apache.niolex.commons.concurrent.ThreadUtil;
import org.apache.niolex.commons.test.TidyUtil;
import org.apache.niolex.commons.util.ThrowableUtil;

public class SystemUtil {
    public static final IOException close(Closeable cl) {
        try {
            if (cl != null) {
                cl.close();
            }
            return null;
        }
        catch (IOException e) {
            return e;
        }
    }

    public static final IOException close(Socket cl) {
        try {
            if (cl != null) {
                cl.close();
            }
            return null;
        }
        catch (IOException e) {
            return e;
        }
    }

    public static final String getSystemProperty(String ... args) {
        for (String s : args) {
            String p = System.getProperty(s);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static final String getSystemPropertyWithDefault(String propName, String defaultValue) {
        try {
            String value = System.getProperty(propName);
            return value == null ? defaultValue : value;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static final int getSystemPropertyAsInt(String propName, int defaultValue) {
        try {
            return Integer.parseInt(System.getProperty(propName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static final boolean defined(String ... args) {
        return SystemUtil.getSystemProperty(args) != null;
    }

    public static final Throwable getRootCause(Throwable e) {
        return ThrowableUtil.getRootCause(e);
    }

    public static final void sleep(long milliseconds) {
        ThreadUtil.sleep(milliseconds);
    }

    public static final void println(String s, Object ... args) {
        System.out.println(String.format(s, args));
    }

    public static final void printTable(int[] colLen, String[] titles, Object ... values) {
        System.out.println(TidyUtil.generateTable(colLen, titles, values));
    }
}

