/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class DateTimeUtil {
    public static final String LONG_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String SHORT_FORMAT = "yyyyMMdd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final int SECOND = 1000;
    public static final int MINUTE = 60000;
    public static final int HOUR = 3600000;
    public static final int DAY = 86400000;
    public static final TimeZone GM_TZ = TimeZone.getTimeZone("GMT");
    public static final TimeZone CN_TZ = TimeZone.getTimeZone("GMT+08:00");
    private static final ThreadLocal<SimpleDateFormat> dateFormatterCache = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat();
        }
    };
    private static TimeZone TIME_ZONE;

    public static final String formatDate2LongStr() {
        return DateTimeUtil.formatDate2LongStr(new Date());
    }

    public static final String formatDate2LongStr(Date date) {
        DateFormat s = DateTimeUtil.getDateFormat(LONG_FORMAT);
        return s.format(date);
    }

    public static final String formatDate2LongStr(long date) {
        DateFormat s = DateTimeUtil.getDateFormat(LONG_FORMAT);
        return s.format(new Date(date));
    }

    public static final String formatDate2DateTimeStr() {
        return DateTimeUtil.formatDate2DateTimeStr(new Date());
    }

    public static final String formatDate2DateTimeStr(Date date) {
        DateFormat s = DateTimeUtil.getDateFormat(DATE_TIME_FORMAT);
        return s.format(date);
    }

    public static final String formatDate2DateTimeStr(long date) {
        DateFormat s = DateTimeUtil.getDateFormat(DATE_TIME_FORMAT);
        return s.format(new Date(date));
    }

    public static final String formatDate2DateStr() {
        return DateTimeUtil.formatDate2DateStr(new Date());
    }

    public static final String formatDate2DateStr(Date date) {
        DateFormat s = DateTimeUtil.getDateFormat(DATE_FORMAT);
        return s.format(date);
    }

    public static final String formatDate2DateStr(long date) {
        DateFormat s = DateTimeUtil.getDateFormat(DATE_FORMAT);
        return s.format(new Date(date));
    }

    public static final String formatDate2TimeStr() {
        return DateTimeUtil.formatDate2TimeStr(new Date());
    }

    public static final String formatDate2TimeStr(Date date) {
        DateFormat s = DateTimeUtil.getDateFormat(TIME_FORMAT);
        return s.format(date);
    }

    public static final String formatDate2TimeStr(long date) {
        DateFormat s = DateTimeUtil.getDateFormat(TIME_FORMAT);
        return s.format(new Date(date));
    }

    public static final String formatDate2ShortStr() {
        return DateTimeUtil.formatDate2ShortStr(new Date());
    }

    public static final String formatDate2ShortStr(Date date) {
        DateFormat s = DateTimeUtil.getDateFormat(SHORT_FORMAT);
        return s.format(date);
    }

    public static final String formatDate2ShortStr(long date) {
        DateFormat s = DateTimeUtil.getDateFormat(SHORT_FORMAT);
        return s.format(new Date(date));
    }

    public static final Date parseDateFromLongStr(String date) throws ParseException {
        DateFormat s = DateTimeUtil.getDateFormat(LONG_FORMAT);
        return s.parse(date);
    }

    public static final Date parseDateFromDateTimeStr(String date) throws ParseException {
        DateFormat s = DateTimeUtil.getDateFormat(DATE_TIME_FORMAT);
        return s.parse(date);
    }

    public static final Date parseDateFromDateStr(String date) throws ParseException {
        DateFormat s = DateTimeUtil.getDateFormat(DATE_FORMAT);
        return s.parse(date);
    }

    public static final Date parseDateFromShortStr(String date) throws ParseException {
        DateFormat s = DateTimeUtil.getDateFormat(SHORT_FORMAT);
        return s.parse(date);
    }

    public static final Date getLastWeekDay(int weekDay) {
        return DateTimeUtil.getLastWeekDay(weekDay, new Date());
    }

    public static final Date getLastWeekDay(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The parameter [date] should not be null!");
        }
        GregorianCalendar cal = DateTimeUtil.getCalender(date, true);
        cal.add(5, -7);
        return cal.getTime();
    }

    public static final Date getLastWeekDay(int weekDay, Date end) {
        if (end == null) {
            throw new IllegalArgumentException("The parameter [end] should not be null!");
        }
        GregorianCalendar cal = DateTimeUtil.getCalender(end, true);
        cal.set(7, weekDay);
        if (!cal.getTime().before(end)) {
            cal.add(5, -7);
        }
        return cal.getTime();
    }

    public static final Date getYesterday() {
        GregorianCalendar cal = DateTimeUtil.getCalender();
        cal.add(5, -1);
        return cal.getTime();
    }

    public static final Date getTodayMidnight() {
        return DateTimeUtil.getCalender().getTime();
    }

    public static final Date getLastHour() {
        GregorianCalendar cal = DateTimeUtil.getCalender(new Date(), false);
        cal.add(11, -1);
        return cal.getTime();
    }

    public static final int getHour(Date date) {
        GregorianCalendar cal = DateTimeUtil.getCalender(date, false);
        return cal.get(11);
    }

    public static final int getMinute(Date date) {
        GregorianCalendar cal = DateTimeUtil.getCalender(date, false);
        return cal.get(12);
    }

    public static final int getSecond(Date date) {
        GregorianCalendar cal = DateTimeUtil.getCalender(date, false);
        return cal.get(13);
    }

    public static final int getWeekDay(Date date) {
        GregorianCalendar cal = DateTimeUtil.getCalender(date, false);
        return cal.get(7);
    }

    public static final int getDayofMonth(Date date) {
        GregorianCalendar cal = DateTimeUtil.getCalender(date, false);
        return cal.get(5);
    }

    public static final int getMonth(Date date) {
        GregorianCalendar cal = DateTimeUtil.getCalender(date, false);
        return cal.get(2);
    }

    public static final int getYear(Date date) {
        GregorianCalendar cal = DateTimeUtil.getCalender(date, false);
        return cal.get(1);
    }

    public static final GregorianCalendar getCalender() {
        return DateTimeUtil.getCalender(new Date(), true);
    }

    public static final GregorianCalendar getCalender(Date date, boolean cleanTime) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (TIME_ZONE != null) {
            cal.setTimeZone(TIME_ZONE);
        }
        if (cleanTime) {
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
        }
        return cal;
    }

    public static final DateFormat getDateFormat(String format) {
        SimpleDateFormat simpleF = dateFormatterCache.get();
        simpleF.applyPattern(format);
        if (TIME_ZONE != null) {
            simpleF.setTimeZone(TIME_ZONE);
        }
        return simpleF;
    }

    public static final void setTimeZone(TimeZone timeZone) {
        TIME_ZONE = timeZone;
    }

    public static final TimeZone getTimeZone() {
        return TIME_ZONE;
    }
}

