/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.niolex.commons.test.TidyUtil;
import org.apache.niolex.commons.util.Runme;
import org.apache.niolex.commons.util.SystemUtil;

public class StopWatch {
    private static final int[] COL_LENS = new int[]{10, 10, 10, 10};
    private static final String[] TOTAL_TITILES = new String[]{"MAX", "MIN", "AVG", "RATE/sec"};
    private static final String[] DISTR_TITILES = new String[]{"DISTRIBU", "FROM", "TO", "COUNT"};
    private final int distributionInterval;
    private final ConcurrentLinkedQueue<Integer> linkList = new ConcurrentLinkedQueue();
    private final LinkedList<Long> rpsList = new LinkedList();
    private final AtomicLong counter = new AtomicLong(0L);
    private Runme rumme;
    private long startTime;
    private int[] distributions;
    private int avg;
    private int max;
    private int min;
    private int rps;

    public StopWatch(int distributionInterval) {
        this.distributionInterval = distributionInterval;
    }

    public void begin(final boolean printDirectly) {
        this.startTime = System.currentTimeMillis();
        this.counter.set(0L);
        this.rumme = new Runme(){
            private int cnt = 0;

            @Override
            public void runMe() {
                Long l = StopWatch.this.counter.getAndSet(0L);
                if (printDirectly) {
                    SystemUtil.println("rps[%03d] -> %d", this.cnt++, l);
                } else {
                    StopWatch.this.rpsList.add(l);
                }
            }
        };
        this.rumme.setInitialSleep(true);
        this.rumme.start();
    }

    public Stop start() {
        return new Stop();
    }

    public void done() {
        Integer c;
        if (this.rumme != null) {
            this.rumme.stopMe();
        }
        int distNum = 1000 / this.distributionInterval + 1;
        long wholeTime = System.currentTimeMillis() - this.startTime;
        long totalCnt = 0L;
        long totalTime = 0L;
        this.distributions = new int[distNum];
        this.max = 0;
        this.min = Integer.MAX_VALUE;
        while ((c = this.linkList.poll()) != null) {
            int k;
            int i = c;
            ++totalCnt;
            totalTime += (long)i;
            if (i > this.max) {
                this.max = i;
            }
            if (i < this.min) {
                this.min = i;
            }
            if ((k = i / this.distributionInterval) >= distNum) {
                k = distNum - 1;
            }
            int n = k;
            this.distributions[n] = this.distributions[n] + 1;
        }
        this.avg = (int)(totalTime / totalCnt);
        this.rps = (int)(totalCnt * 1000L / wholeTime);
    }

    public void print() {
        System.out.print(this.report());
    }

    public String report() {
        StringBuilder sb = new StringBuilder();
        sb.append(TidyUtil.generateTable(COL_LENS, TOTAL_TITILES, this.max, this.min, this.avg, this.rps));
        sb.append('\n');
        int l = 0;
        int r = this.distributionInterval;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.distributions.length; ++i) {
            if (this.distributions[i] > 0) {
                list.add(i);
                list.add(l);
                if (i == this.distributions.length - 1) {
                    list.add("    ~");
                } else {
                    list.add(r);
                }
                list.add(this.distributions[i]);
            }
            l = r;
            r += this.distributionInterval;
        }
        sb.append(TidyUtil.generateTable(COL_LENS, DISTR_TITILES, list.toArray()));
        sb.append('\n');
        if (!this.rpsList.isEmpty()) {
            sb.append("------RPS-LIST-----\n");
            Iterator it = this.rpsList.iterator();
            while (it.hasNext()) {
                sb.append(it.next()).append('\n');
            }
            sb.append("--------END--------\n");
        }
        return sb.toString();
    }

    public int[] getDistributions() {
        return this.distributions;
    }

    public int getAvg() {
        return this.avg;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public int getRps() {
        return this.rps;
    }

    public LinkedList<Long> getRpsList() {
        return this.rpsList;
    }

    public class Stop {
        private long startTime = System.currentTimeMillis();

        private Stop() {
        }

        public void stop() {
            long time = System.currentTimeMillis() - this.startTime;
            StopWatch.this.linkList.add(new Integer((int)time));
            StopWatch.this.counter.incrementAndGet();
        }
    }
}

