/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class MockUtil {
    private static Random generator = new Random();

    public static final int randInt(int max) {
        return generator.nextInt(max);
    }

    public static final int randInt(int from, int to) {
        return generator.nextInt(to - from) + from;
    }

    public static final long randLong() {
        return generator.nextLong();
    }

    public static final int[] randIntArray(int length) {
        int[] ar = new int[length];
        for (int i = 0; i < length; ++i) {
            ar[i] = generator.nextInt();
        }
        return ar;
    }

    public static final byte[] randByteArray(int length) {
        byte[] ar = new byte[length];
        generator.nextBytes(ar);
        return ar;
    }

    public static final String randUUID() {
        return UUID.randomUUID().toString();
    }

    public static final String randString() {
        return MockUtil.randString(8);
    }

    public static final String randString(int length) {
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    public static final int[] reorderIntArray(int length) {
        int[] ar = new int[length];
        for (int i = 0; i < length; ++i) {
            ar[i] = i;
        }
        return MockUtil.reorderIntArray(ar);
    }

    public static final int[] reorderIntArray(int[] ar) {
        int length;
        for (int i = length = ar.length; i > 1; --i) {
            int j = generator.nextInt(i);
            int k = ar[i - 1];
            ar[i - 1] = ar[j];
            ar[j] = k;
        }
        return ar;
    }
}

