/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import org.apache.niolex.commons.test.TidyUtil;

public class MappingGenerator {
    public static final String generateFieldName(String columnName) {
        StringBuilder sb = new StringBuilder();
        columnName = columnName.toLowerCase();
        boolean upperFlag = false;
        for (int i = 0; i < columnName.length(); ++i) {
            char c = columnName.charAt(i);
            if (c == '_') {
                upperFlag = true;
                continue;
            }
            if (upperFlag) {
                upperFlag = false;
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String tidyDBColumnName(String originalColumnName) {
        int space;
        int dot;
        int start = 0;
        while (Character.isWhitespace(originalColumnName.charAt(start))) {
            ++start;
        }
        int end = originalColumnName.length() - 1;
        while (Character.isWhitespace(originalColumnName.charAt(end))) {
            --end;
        }
        String s = originalColumnName.substring(start, end + 1);
        if (s.indexOf(40) != -1) {
            int r = s.lastIndexOf(41);
            if (r == -1) {
                throw new IllegalArgumentException("Not a valid column name: " + originalColumnName);
            }
            s = s.substring(r + 1);
        }
        if ((dot = s.lastIndexOf(46)) != -1) {
            s = s.substring(dot + 1);
        }
        if ((space = s.lastIndexOf(32)) != -1) {
            s = s.substring(space + 1);
        }
        return s;
    }

    public static final String generateMapping(String template, String select) {
        StringBuilder sb = new StringBuilder();
        select = select.toUpperCase();
        int start = select.indexOf("SELECT") + 7;
        int end = select.indexOf("FROM") - 1;
        if (start == 6) {
            start = 0;
        }
        if (end == -2) {
            end = select.length();
        }
        int right = 0;
        for (int left = start; left < end; ++left) {
            block5: for (int j = left; j < end; ++j) {
                switch (select.charAt(j)) {
                    case ',': {
                        right = j;
                        break block5;
                    }
                    case '(': {
                        j = TidyUtil.matchParenthesis(select, j) + 1;
                    }
                    default: {
                        continue block5;
                    }
                }
            }
            if (right == 0) {
                right = end;
            }
            String s = select.substring(left, right);
            left = right;
            right = 0;
            s = MappingGenerator.tidyDBColumnName(s);
            sb.append(String.format(template, MappingGenerator.generateFieldName(s), s)).append('\n');
        }
        return sb.toString();
    }
}

