/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.stream;

import java.io.IOException;
import java.io.InputStream;
import org.apache.niolex.commons.util.SystemUtil;

public class LimitRateInputStream
extends InputStream {
    private static final int CHECK_SIZE_THRESHOLD = 10240;
    private static final int MILLS_INTO_NANO_SECOND = 1000000;
    private static final int HOUR_INTO_NANO_SECOND = 817405952;
    private final InputStream delegate;
    private final double expectedRate;
    private long startedTime = 0L;
    private long cnt = 0L;
    private long chunk = 0L;

    public LimitRateInputStream(InputStream delegate) {
        this(delegate, 20.0);
    }

    public LimitRateInputStream(InputStream delegate, double rate) {
        this.delegate = delegate;
        this.expectedRate = rate * 1024.0 * 1024.0 / 1.0E9;
        this.reset(0);
    }

    private void reset(int offset) {
        this.startedTime = System.nanoTime();
        this.cnt = offset;
        this.chunk = 10240L;
    }

    private void checkSize(int size) {
        this.cnt += (long)size;
        if (this.cnt > this.chunk) {
            long needTime = (long)((double)this.cnt / this.expectedRate);
            long usedTime = System.nanoTime() - this.startedTime;
            long sleepTime = needTime - usedTime + 300000L;
            if (sleepTime > 1000000L) {
                SystemUtil.sleep(sleepTime / 1000000L + 1L);
            } else if (sleepTime > 0L) {
                Thread.yield();
            }
            if (usedTime > 817405952L) {
                this.reset(0);
            } else {
                this.chunk += 10240L;
            }
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int size = this.delegate.read(b, off, len);
        this.checkSize(size);
        return size;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int size = this.delegate.read(b);
        this.checkSize(size);
        return size;
    }

    @Override
    public int read() throws IOException {
        this.checkSize(1);
        return this.delegate.read();
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

