/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.reflect;

import org.apache.commons.lang3.ClassUtils;
import org.apache.niolex.commons.test.Check;

public class TypeUtil
extends ClassUtils {
    public static boolean typeMatches(Class<?> aType, Class<?> bType) {
        if (aType.isPrimitive()) {
            if (!bType.isPrimitive()) {
                bType = TypeUtil.wrapperToPrimitive(bType);
            }
            return aType.equals(bType);
        }
        if (bType.isPrimitive()) {
            return bType.equals(TypeUtil.wrapperToPrimitive(aType));
        }
        return aType.equals(bType);
    }

    public static <T> T safeCast(Object original, Class<T> destination) {
        if (original == null) {
            return null;
        }
        if (destination.isAssignableFrom(original.getClass())) {
            return (T)original;
        }
        return TypeUtil.widenPrimitive(original, destination);
    }

    public static <T> T widenPrimitive(Object original, Class<T> destination) {
        Class<T> toPrim = TypeUtil.wrapperToPrimitive(destination);
        if (toPrim == null && destination.isPrimitive()) {
            toPrim = destination;
        }
        if (toPrim == null) {
            return (T)original;
        }
        if (TypeUtil.isAssignable(original.getClass(), toPrim)) {
            Number n = null;
            if (original instanceof Number) {
                n = (Number)original;
            } else if (original instanceof Character) {
                n = (int)((Character)original).charValue();
            } else {
                return (T)original;
            }
            if (toPrim.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(n.byteValue());
            }
            if (toPrim.equals(Short.TYPE)) {
                return (T)Short.valueOf(n.shortValue());
            }
            if (toPrim.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(n.intValue());
            }
            if (toPrim.equals(Long.TYPE)) {
                return (T)Long.valueOf(n.longValue());
            }
            if (toPrim.equals(Float.TYPE)) {
                return (T)Float.valueOf(n.floatValue());
            }
            if (toPrim.equals(Double.TYPE)) {
                return (T)Double.valueOf(n.doubleValue());
            }
            Check.eq(toPrim, Character.TYPE, "A new primitive type found, please contact the author! - " + toPrim);
            return (T)Character.valueOf((char)n.intValue());
        }
        throw new ClassCastException("Can not cast from " + original.getClass() + " to " + destination);
    }
}

