/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.niolex.commons.collection.CollectionUtil;
import org.apache.niolex.commons.reflect.ItemNotFoundException;
import org.apache.niolex.commons.reflect.MethodFilter;

public class MethodUtil {
    public static final List<Class<?>> getAllTypes(Object obj) {
        return MethodUtil.getAllTypes(obj.getClass());
    }

    public static final List<Class<?>> getAllTypes(Class<?> clazz) {
        ArrayList list = new ArrayList();
        ArrayList interfaces = new ArrayList();
        do {
            list.add(clazz);
            CollectionUtil.addAll(interfaces, clazz.getInterfaces());
        } while ((clazz = clazz.getSuperclass()) != null);
        HashSet<Class> clsSet = new HashSet<Class>();
        for (int i = 0; i < interfaces.size(); ++i) {
            clazz = (Class)interfaces.get(i);
            if (clsSet.contains(clazz)) continue;
            clsSet.add(clazz);
            list.add(clazz);
            CollectionUtil.addAll(interfaces, clazz.getInterfaces());
        }
        return list;
    }

    public static final List<Method> getAllMethodsIncludeInterfaces(Class<?> clazz) {
        ArrayList<Method> outList = new ArrayList<Method>();
        for (Class<?> type : MethodUtil.getAllTypes(clazz)) {
            CollectionUtil.addAll(outList, type.getDeclaredMethods());
        }
        return outList;
    }

    public static final List<Method> getAllMethods(Class<?> clazz) {
        ArrayList<Method> outList = new ArrayList<Method>();
        do {
            CollectionUtil.addAll(outList, clazz.getDeclaredMethods());
        } while ((clazz = clazz.getSuperclass()) != null);
        return outList;
    }

    public static final List<Method> getThisMethods(Class<?> clazz) {
        ArrayList<Method> outList = new ArrayList<Method>();
        CollectionUtil.addAll(outList, clazz.getDeclaredMethods());
        return outList;
    }

    public static final List<Method> getMethods(Class<?> clazz, Filter filter) {
        List<Method> raw = null;
        raw = filter.isIncludeInterfaces() ? MethodUtil.getAllMethodsIncludeInterfaces(clazz) : (filter.isIncludeSuper() ? MethodUtil.getAllMethods(clazz) : MethodUtil.getThisMethods(clazz));
        ArrayList<Method> outList = new ArrayList<Method>();
        for (Method m : raw) {
            if (!filter.isValid(m)) continue;
            outList.add(m);
        }
        return outList;
    }

    public static final List<Method> getMethods(Class<?> clazz, String methodName) {
        return MethodUtil.getMethods(clazz, MethodFilter.create().includeSuper().includeStatic().methodName(methodName));
    }

    public static final Method getFirstMethod(Class<?> clazz, String methodName) {
        List<Method> list = MethodUtil.getMethods(clazz, methodName);
        if (list.size() > 0) {
            return list.get(0);
        }
        throw new ItemNotFoundException("Method not found.", null);
    }

    public static final Method getFirstMethod(Object host, String methodName) {
        return MethodUtil.getFirstMethod(host.getClass(), methodName);
    }

    public static final Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            clazz = clazz.getSuperclass();
            if (clazz != null) {
                return MethodUtil.getMethod(clazz, methodName, parameterTypes);
            }
            throw new ItemNotFoundException("Method not found.", e);
        }
    }

    public static final List<Method> getMethodsParamRelax(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return MethodUtil.getMethods(clazz, MethodFilter.create().includeSuper().includeStatic().methodName(methodName).parameterTypes(parameterTypes));
    }

    public static final Object invokeMethod(Object host, Method m, Object ... args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        m.setAccessible(true);
        return m.invoke(host, args);
    }

    public static final Object invokeMethod(Object host, String methodName, Object ... args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtil.invokeMethod(host, methodName, parameterTypes, args);
    }

    public static final Object invokeMethod(Object host, String methodName, Class<?>[] parameterTypes, Object ... args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        List<Method> methods = MethodUtil.getMethodsParamRelax(host.getClass(), methodName, parameterTypes);
        if (methods.size() > 0) {
            Method m = methods.get(0);
            m.setAccessible(true);
            return m.invoke(host, args);
        }
        throw new ItemNotFoundException("Method not found.", null);
    }

    public static Object invokePublicMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])args);
    }

    public static interface Filter {
        public boolean isIncludeInterfaces();

        public boolean isIncludeSuper();

        public boolean isValid(Method var1);
    }
}

