/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassUtils;
import org.apache.niolex.commons.reflect.MethodUtil;

public class MethodFilter
implements MethodUtil.Filter {
    private boolean includeInterfaces;
    private boolean includeSuper;
    private boolean includeStatic;
    private boolean includeSynthetic;
    private boolean includeAbstract;
    private String methodName;
    private Class<?> returnType;
    private Class<?>[] parameterTypes;

    public static final MethodFilter c() {
        return MethodFilter.create();
    }

    public static final MethodFilter create() {
        return new MethodFilter();
    }

    @Override
    public boolean isIncludeInterfaces() {
        return this.includeInterfaces;
    }

    @Override
    public boolean isIncludeSuper() {
        return this.includeSuper;
    }

    @Override
    public boolean isValid(Method m) {
        if (this.methodName != null && !this.methodName.equals(m.getName())) {
            return false;
        }
        if (this.returnType != null && !ClassUtils.isAssignable(m.getReturnType(), this.returnType, (boolean)true)) {
            return false;
        }
        if (this.parameterTypes != null && !ClassUtils.isAssignable((Class[])this.parameterTypes, (Class[])m.getParameterTypes(), (boolean)true)) {
            return false;
        }
        if (!this.includeStatic && Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        if (!this.includeAbstract && Modifier.isAbstract(m.getModifiers())) {
            return false;
        }
        return this.includeSynthetic || !m.isSynthetic();
    }

    public MethodFilter includeAll() {
        this.includeSuper = true;
        this.includeInterfaces = true;
        this.includeStatic = true;
        this.includeSynthetic = true;
        this.includeAbstract = true;
        return this;
    }

    public MethodFilter includeInterfaces() {
        this.includeSuper = true;
        this.includeInterfaces = true;
        this.includeAbstract = true;
        return this;
    }

    public MethodFilter includeSuper() {
        this.includeSuper = true;
        return this;
    }

    public MethodFilter includeStatic() {
        this.includeStatic = true;
        return this;
    }

    public MethodFilter includeSynthetic() {
        this.includeSynthetic = true;
        return this;
    }

    public MethodFilter includeAbstract() {
        this.includeAbstract = true;
        return this;
    }

    public MethodFilter n(String methodName) {
        return this.methodName(methodName);
    }

    public MethodFilter methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public MethodFilter r(Class<?> returnType) {
        return this.returnType(returnType);
    }

    public MethodFilter returnType(Class<?> returnType) {
        this.returnType = returnType;
        return this;
    }

    public MethodFilter p(Class<?> ... parameterTypes) {
        return this.parameterTypes(parameterTypes);
    }

    public MethodFilter parameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
        return this;
    }
}

