/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.reflect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.niolex.commons.collection.CollectionUtil;
import org.apache.niolex.commons.config.PropertiesWrapper;
import org.apache.niolex.commons.reflect.ItemNotFoundException;

public abstract class FieldUtil {
    public static final <T> T getValue(Object host, String fieldName) {
        try {
            return (T)FieldUtil.safeGetFieldValue(host, FieldUtil.getField(host.getClass(), fieldName));
        }
        catch (NoSuchFieldException e) {
            throw new ItemNotFoundException("Field not found in host.", e);
        }
    }

    public static final void setValue(Object host, String fieldName, Object value) {
        try {
            FieldUtil.setFieldValue(host, FieldUtil.getField(host.getClass(), fieldName), value);
        }
        catch (NoSuchFieldException e) {
            throw new ItemNotFoundException("Field not found in host.", e);
        }
    }

    public static final void setValueAutoConvert(Object host, String fieldName, String value) {
        try {
            FieldUtil.setFieldValueAutoConvert(host, FieldUtil.getField(host.getClass(), fieldName), value);
        }
        catch (NoSuchFieldException e) {
            throw new ItemNotFoundException("Field not found in host.", e);
        }
    }

    public static final List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> outList = new ArrayList<Field>();
        do {
            CollectionUtil.addAll(outList, clazz.getDeclaredFields());
        } while ((clazz = clazz.getSuperclass()) != null);
        return outList;
    }

    public static final List<Field> getFields(Class<?> clazz, Filter filter) {
        ArrayList<Field> outList = new ArrayList<Field>();
        do {
            for (Field f : clazz.getDeclaredFields()) {
                if (!filter.isValid(f)) continue;
                outList.add(f);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return outList;
    }

    public static final Field getField(Class<?> clazz, String name) throws SecurityException, NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            clazz = clazz.getSuperclass();
            if (clazz == null) {
                throw e;
            }
            return FieldUtil.getField(clazz, name);
        }
    }

    public static final <T> T getFieldValue(Object host, Field f) {
        return (T)FieldUtil.safeGetFieldValue(host, f);
    }

    public static final Object safeGetFieldValue(Object host, Field f) {
        f.setAccessible(true);
        return FieldUtil.unsafeGetFieldValue(host, f);
    }

    public static final Object unsafeGetFieldValue(Object host, Field f) {
        try {
            return f.get(host);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to access the field.", e);
        }
    }

    public static final void setFieldValue(Object host, Field f, Object value) {
        f.setAccessible(true);
        FieldUtil.unsafeSetFieldValue(host, f, value);
    }

    public static final void unsafeSetFieldValue(Object host, Field f, Object value) {
        try {
            f.set(host, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to access the field.", e);
        }
    }

    public static final void setFieldValue(Object host, Field f, boolean value) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        f.setBoolean(host, value);
    }

    public static final void setFieldValue(Object host, Field f, byte value) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        f.setByte(host, value);
    }

    public static final void setFieldValue(Object host, Field f, char value) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        f.setChar(host, value);
    }

    public static final void setFieldValue(Object host, Field f, short value) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        f.setShort(host, value);
    }

    public static final void setFieldValue(Object host, Field f, int value) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        f.setInt(host, value);
    }

    public static final void setFieldValue(Object host, Field f, long value) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        f.setLong(host, value);
    }

    public static final void setFieldValue(Object host, Field f, float value) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        f.setFloat(host, value);
    }

    public static final void setFieldValue(Object host, Field f, double value) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        f.setDouble(host, value);
    }

    public static final void setFieldValueAutoConvert(Object host, Field field, String value) {
        field.setAccessible(true);
        FieldUtil.unsafeSetFieldValueAutoConvert(host, field, value);
    }

    public static final void unsafeSetFieldValueAutoConvert(Object host, Field field, String value) {
        block20: {
            Class<?> type = field.getType();
            try {
                if (type == String.class) {
                    field.set(host, value);
                    break block20;
                }
                if (type == Date.class) {
                    Date d = new Date(Long.parseLong(value));
                    field.set(host, d);
                    break block20;
                }
                if (type == Integer.class) {
                    field.set(host, Integer.parseInt(value));
                    break block20;
                }
                if (type == Integer.TYPE) {
                    field.setInt(host, Integer.parseInt(value));
                    break block20;
                }
                if (type == Long.class) {
                    field.set(host, Long.parseLong(value));
                    break block20;
                }
                if (type == Long.TYPE) {
                    field.setLong(host, Long.parseLong(value));
                    break block20;
                }
                if (type == Short.class) {
                    field.set(host, Short.parseShort(value));
                    break block20;
                }
                if (type == Short.TYPE) {
                    field.setShort(host, Short.parseShort(value));
                    break block20;
                }
                if (type == Byte.class) {
                    field.set(host, Byte.parseByte(value));
                    break block20;
                }
                if (type == Byte.TYPE) {
                    field.setByte(host, Byte.parseByte(value));
                    break block20;
                }
                if (type == Boolean.class) {
                    field.set(host, PropertiesWrapper.parseBoolean(value));
                    break block20;
                }
                if (type == Boolean.TYPE) {
                    field.setBoolean(host, PropertiesWrapper.parseBoolean(value));
                    break block20;
                }
                if (type == Character.class) {
                    field.set(host, Character.valueOf(value.charAt(0)));
                    break block20;
                }
                if (type == Character.TYPE) {
                    field.setChar(host, value.charAt(0));
                    break block20;
                }
                if (type == Double.class) {
                    field.set(host, Double.parseDouble(value));
                    break block20;
                }
                if (type == Double.TYPE) {
                    field.setDouble(host, Double.parseDouble(value));
                    break block20;
                }
                if (type == Float.class) {
                    field.set(host, Float.valueOf(Float.parseFloat(value)));
                    break block20;
                }
                if (type == Float.TYPE) {
                    field.setFloat(host, Float.parseFloat(value));
                    break block20;
                }
                throw new UnsupportedOperationException("The Field Type [" + type.getSimpleName() + "] Is Not Supported.");
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to access the field.", e);
            }
        }
    }

    public static interface Filter {
        public boolean isValid(Field var1);
    }
}

