/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.reflect;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.niolex.commons.reflect.FieldUtil;

public class FieldResult<T> {
    private final List<Field> fields;
    private Object host;
    private Field field;
    private boolean onlyOne;

    public FieldResult(Object host, List<Field> fields) {
        this.host = host;
        this.fields = fields;
        if (fields.size() == 1) {
            this.onlyOne = true;
            this.field = fields.get(0);
        }
    }

    public FieldResult<T> host(Object host) {
        this.host = host;
        return this;
    }

    public List<Field> results() {
        return this.fields;
    }

    public FieldResult<T> first() {
        if (this.fields.size() < 1) {
            throw new IllegalStateException("No field found.");
        }
        this.onlyOne = true;
        this.field = this.fields.get(0);
        return this;
    }

    public FieldResult<T> last() {
        if (this.fields.size() < 1) {
            throw new IllegalStateException("No field found.");
        }
        this.onlyOne = true;
        this.field = this.fields.get(this.fields.size() - 1);
        return this;
    }

    public Field result() {
        if (this.onlyOne) {
            return this.field;
        }
        throw new IllegalStateException("Multiple fields found, please filter out one first!");
    }

    public T get() {
        if (this.onlyOne) {
            return FieldUtil.getFieldValue(this.host, this.field);
        }
        throw new IllegalStateException("Multiple fields found, please filter out one first!");
    }

    public void set(T t) {
        if (!this.onlyOne) {
            throw new IllegalStateException("Multiple fields found, please filter out one first!");
        }
        FieldUtil.setFieldValue(this.host, this.field, t);
    }
}

