/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.reflect;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.niolex.commons.reflect.FieldResult;
import org.apache.niolex.commons.reflect.FieldUtil;
import org.apache.niolex.commons.reflect.TypeUtil;
import org.apache.niolex.commons.test.Check;

public class FieldFilter<FT>
implements FieldUtil.Filter {
    private final List<FieldUtil.Filter> filterList = Lists.newArrayList();
    private Object host;
    private Class<?> clazz;

    public static final <CT> FieldFilter<CT> c() {
        return FieldFilter.create();
    }

    public static final <CT> FieldFilter<CT> create() {
        return new FieldFilter();
    }

    public static final <ET> FieldFilter<ET> t(Class<ET> type) {
        return FieldFilter.exactType(type);
    }

    public static final <ET> FieldFilter<ET> exactType(final Class<ET> type) {
        FieldFilter e = FieldFilter.c();
        e.filterList.add(new FieldUtil.Filter(){

            @Override
            public boolean isValid(Field f) {
                return TypeUtil.typeMatches(f.getType(), type);
            }
        });
        return e;
    }

    public static final <QT> FieldFilter<QT> to(Class<QT> type) {
        return FieldFilter.retrieveAs(type);
    }

    public static final <QT> FieldFilter<QT> retrieveAs(final Class<QT> type) {
        FieldFilter e = FieldFilter.c();
        e.add(new FieldUtil.Filter(){

            @Override
            public boolean isValid(Field f) {
                return TypeUtil.isAssignable(f.getType(), (Class)type);
            }
        });
        return e;
    }

    public static final <ST> FieldFilter<ST> setWith(final Class<ST> type) {
        FieldFilter e = FieldFilter.c();
        e.add(new FieldUtil.Filter(){

            @Override
            public boolean isValid(Field f) {
                return TypeUtil.isAssignable((Class)type, f.getType());
            }
        });
        return e;
    }

    @Override
    public boolean isValid(Field f) {
        for (FieldUtil.Filter filter : this.filterList) {
            if (filter.isValid(f)) continue;
            return false;
        }
        return true;
    }

    public FieldFilter<FT> add(FieldUtil.Filter filter) {
        this.filterList.add(filter);
        return this;
    }

    public final FieldResult<FT> find() {
        if (this.clazz != null) {
            return new FieldResult(this.host, FieldUtil.getFields(this.clazz, this));
        }
        throw new IllegalStateException("Please set host variable or class first!");
    }

    public final FieldFilter<FT> host(Object host) {
        this.host = host;
        this.clazz = host.getClass();
        return this;
    }

    public final FieldFilter<FT> clazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public final FieldFilter<FT> name(String fieldName) {
        return this.withName(fieldName);
    }

    public final FieldFilter<FT> withName(final String fieldName) {
        Check.notNull((Object)fieldName, (String)"fieldName should not be null.", (Object[])new Object[0]);
        return this.add(new FieldUtil.Filter(){

            @Override
            public boolean isValid(Field f) {
                return fieldName.equals(f.getName());
            }
        });
    }

    public final FieldFilter<FT> nameLike(String nameRegex) {
        final Pattern p = Pattern.compile(nameRegex);
        return this.add(new FieldUtil.Filter(){

            @Override
            public boolean isValid(Field f) {
                return p.matcher(f.getName()).matches();
            }
        });
    }

    public final FieldFilter<FT> onlyStatic() {
        return this.add(new FieldUtil.Filter(){

            @Override
            public boolean isValid(Field f) {
                return Modifier.isStatic(f.getModifiers());
            }
        });
    }

    public final FieldFilter<FT> noStatic() {
        return this.add(new FieldUtil.Filter(){

            @Override
            public boolean isValid(Field f) {
                return !Modifier.isStatic(f.getModifiers());
            }
        });
    }

    public final FieldFilter<FT> noSynthetic() {
        return this.add(new FieldUtil.Filter(){

            @Override
            public boolean isValid(Field f) {
                return !f.isSynthetic();
            }
        });
    }
}

