/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.net;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.apache.niolex.commons.compress.JacksonUtil;
import org.apache.niolex.commons.net.ErrorDecoder;
import org.apache.niolex.commons.net.HTTPResult;

public class RESTResult<T> {
    private final HTTPResult result;
    private final int respCode;
    private final T response;
    private final Exception error;

    public RESTResult(HTTPResult result, Class<T> clazz, ErrorDecoder errorDecoder) throws IOException {
        this.result = result;
        this.respCode = result.getRespCode();
        this.response = this.respCode >= 200 && this.respCode < 300 ? JacksonUtil.bin2Obj(result.getRespBody(), clazz) : null;
        this.error = this.respCode >= 400 && errorDecoder != null ? errorDecoder.decode(this.respCode, result.getRespBody()) : null;
    }

    public RESTResult(HTTPResult result, TypeReference<T> typeRef, ErrorDecoder errorDecoder) throws IOException {
        this.result = result;
        this.respCode = result.getRespCode();
        this.response = this.respCode >= 200 && this.respCode < 300 ? JacksonUtil.bin2Obj(result.getRespBody(), typeRef) : null;
        this.error = this.respCode >= 400 && errorDecoder != null ? errorDecoder.decode(this.respCode, result.getRespBody()) : null;
    }

    public HTTPResult getResult() {
        return this.result;
    }

    public int getRespCode() {
        return this.respCode;
    }

    public T getResponse() {
        return this.response;
    }

    public Exception getError() {
        return this.error;
    }
}

