/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.net;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Map;
import org.apache.niolex.commons.compress.JacksonUtil;
import org.apache.niolex.commons.net.ErrorDecoder;
import org.apache.niolex.commons.net.HTTPClient;
import org.apache.niolex.commons.net.HTTPResult;
import org.apache.niolex.commons.net.NetException;
import org.apache.niolex.commons.net.RESTResult;

public class RESTClient
extends HTTPClient {
    private ErrorDecoder errorDecoder = ErrorDecoder.RESTDecoder.INSTANCE;

    public RESTClient(String endPoint, String charset) {
        super(endPoint, charset);
    }

    public RESTClient(String endPoint, String charset, int connectTimeout, int readTimeout) {
        super(endPoint, charset, connectTimeout, readTimeout);
    }

    public void setErrorDecoder(ErrorDecoder errorDecoder) {
        this.errorDecoder = errorDecoder;
    }

    public <T> RESTResult<T> get(String path, Class<T> clazz, Map<String, String> params) throws NetException, IOException {
        HTTPResult res = this.get(path, params);
        return new RESTResult<T>(res, clazz, this.errorDecoder);
    }

    public <T> RESTResult<T> get(String path, TypeReference<T> typeRef, Map<String, String> params) throws NetException, IOException {
        HTTPResult res = this.get(path, params);
        return new RESTResult<T>(res, typeRef, this.errorDecoder);
    }

    public <T> RESTResult<T> delete(String path, Class<T> clazz, Map<String, String> params) throws NetException, IOException {
        HTTPResult res = this.delete(path, params);
        return new RESTResult<T>(res, clazz, this.errorDecoder);
    }

    public <T> RESTResult<T> delete(String path, TypeReference<T> typeRef, Map<String, String> params) throws NetException, IOException {
        HTTPResult res = this.delete(path, params);
        return new RESTResult<T>(res, typeRef, this.errorDecoder);
    }

    public <T> RESTResult<T> post(String path, Class<T> clazz, Object requestBody) throws NetException, IOException {
        HTTPResult res = this.post(path, this.obj2json(requestBody));
        return new RESTResult<T>(res, clazz, this.errorDecoder);
    }

    public <T> RESTResult<T> post(String path, TypeReference<T> typeRef, Object requestBody) throws NetException, IOException {
        HTTPResult res = this.post(path, this.obj2json(requestBody));
        return new RESTResult<T>(res, typeRef, this.errorDecoder);
    }

    public <T> RESTResult<T> put(String path, Class<T> clazz, Object requestBody) throws NetException, IOException {
        HTTPResult res = this.put(path, this.obj2json(requestBody));
        return new RESTResult<T>(res, clazz, this.errorDecoder);
    }

    public <T> RESTResult<T> put(String path, TypeReference<T> typeRef, Object requestBody) throws NetException, IOException {
        HTTPResult res = this.put(path, this.obj2json(requestBody));
        return new RESTResult<T>(res, typeRef, this.errorDecoder);
    }

    public String obj2json(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return o.toString();
        }
        return JacksonUtil.obj2Str(o);
    }
}

