/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.niolex.commons.codec.IntegerUtil;
import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.net.NetException;
import org.apache.niolex.commons.stream.StreamUtil;
import org.apache.niolex.commons.test.Check;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DownloadUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadUtil.class);
    private static final ThreadLocal<byte[]> BUFFER_CACHE = new ThreadLocal();
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int READ_TIMEOUT = 6000;
    private static final int BUFFER_SIZE = 16384;
    private static final int MATERIAL_SIZE = 30720;
    private static final int MAX_SIZE = 0x1400000;
    private static final int MIN_SIZE = 10;
    private static volatile boolean useThreadLocalCache = true;

    public static void setUseThreadLocalCache(boolean useCache) {
        useThreadLocalCache = useCache;
    }

    public static byte[] downloadFile(String strUrl) throws NetException {
        return DownloadUtil.downloadFile(strUrl, 6000, 6000, 0x1400000, null);
    }

    public static byte[] downloadFile(String strUrl, int maxFileSize) throws NetException {
        return DownloadUtil.downloadFile(strUrl, 6000, 6000, maxFileSize, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] downloadFile(String strUrl, int connectTimeout, int readTimeout, int maxFileSize, Boolean useCache) throws NetException {
        byte[] byArray;
        LOG.debug("Start to download file [{}], C{}R{}M{}.", new Object[]{strUrl, connectTimeout, readTimeout, maxFileSize});
        InputStream in = null;
        try {
            URL url = new URL(strUrl);
            URLConnection ucon = url.openConnection();
            ucon.setConnectTimeout(connectTimeout);
            ucon.setReadTimeout(readTimeout);
            ucon.setDoOutput(false);
            ucon.setDoInput(true);
            ucon.connect();
            if (ucon instanceof HttpURLConnection) {
                DownloadUtil.validateHttpCode(strUrl, (HttpURLConnection)ucon);
            }
            in = ucon.getInputStream();
            int contentLength = ucon.getContentLength();
            DownloadUtil.validateContentLength(strUrl, contentLength, 10, maxFileSize);
            byte[] ret = null;
            ret = contentLength > 0 ? DownloadUtil.commonDownload(in, contentLength) : DownloadUtil.unusualDownload(in, 10, maxFileSize, strUrl, useCache);
            LOG.debug("Succeeded to download file [{}] size {}.", (Object)strUrl, (Object)ret.length);
            byArray = ret;
        }
        catch (NetException e) {
            try {
                LOG.info(e.getMessage());
                throw e;
                catch (Exception e2) {
                    String msg = "Failed to download file " + strUrl + " msg=" + e2.toString();
                    LOG.warn(msg);
                    throw new NetException(NetException.ExCode.IOEXCEPTION, msg, e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(in);
                throw throwable;
            }
        }
        StreamUtil.closeStream(in);
        return byArray;
    }

    public static byte[] commonDownload(InputStream in, int size) throws IOException {
        int count;
        byte[] byteBuf = new byte[size];
        int total = 0;
        while ((count = in.read(byteBuf, total, size - total)) > 0) {
            total += count;
        }
        Check.eq(total, size, "The downloaded File is not completed.");
        return byteBuf;
    }

    public static byte[] unusualDownload(InputStream in, int minFileSize, int maxFileSize, String strUrl, Boolean useCache) throws NetException, IOException {
        int count;
        byte[] byteBuf = DownloadUtil.getByteBuffer(useCache == null ? useThreadLocalCache : useCache);
        byte[] ret = null;
        int total = 0;
        int size = byteBuf.length;
        while ((count = in.read(byteBuf, total, size - total)) > 0) {
            total += count;
        }
        if (count == -1) {
            ret = ArrayUtils.subarray((byte[])byteBuf, (int)0, (int)total);
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(30720);
            count = total;
            total = 0;
            do {
                bos.write(byteBuf, 0, count);
                if ((total += count) <= maxFileSize) continue;
                throw new NetException(NetException.ExCode.FILE_TOO_LARGE, "File " + strUrl + " size exceed [" + maxFileSize + "] download stoped.");
            } while ((count = in.read(byteBuf)) > 0);
            ret = bos.toByteArray();
        }
        DownloadUtil.validateContentLength(strUrl, ret.length, minFileSize, maxFileSize);
        return ret;
    }

    public static void validateContentLength(String strUrl, int contentLength, int minFileSize, int maxFileSize) throws NetException {
        if (contentLength > maxFileSize) {
            throw new NetException(NetException.ExCode.FILE_TOO_LARGE, "File " + strUrl + " content size [" + contentLength + "], max allowed [" + maxFileSize + "] too large; download stoped.");
        }
        if (contentLength != -1 && contentLength < minFileSize) {
            throw new NetException(NetException.ExCode.FILE_TOO_SMALL, "File " + strUrl + " content size [" + contentLength + "] too small, it indicates error.");
        }
    }

    public static void validateHttpCode(String strUrl, HttpURLConnection httpCon) throws NetException, IOException {
        DownloadUtil.validateHttpCode(strUrl, httpCon.getResponseCode(), httpCon.getResponseMessage());
    }

    public static void validateHttpCode(String strUrl, int respCode, String respMsg) throws NetException {
        if (!IntegerUtil.isIn(respCode, 200, 203, 301, 302)) {
            throw new NetException(NetException.ExCode.INVALID_SERVER_RESPONSE, "File " + strUrl + " invalid response " + respCode + " [" + respMsg + "]");
        }
    }

    public static byte[] getByteBuffer(boolean useCache) {
        if (useCache) {
            byte[] byteBuf = BUFFER_CACHE.get();
            if (byteBuf == null) {
                byteBuf = new byte[16384];
                BUFFER_CACHE.set(byteBuf);
            }
            return byteBuf;
        }
        return new byte[16384];
    }

    public static boolean isTextFileType(String contentType) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return false;
        }
        contentType = contentType.toLowerCase();
        return StringUtil.containsAny((CharSequence)contentType, (CharSequence[])new CharSequence[]{"text", "xml", "json", "html", "txt"});
    }
}

