/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.niolex.commons.stream.StreamUtil;

public class IgnoreException {
    public static KeyFactory getKeyFactory(String algorithm) {
        try {
            return KeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Your JDK don't support " + algorithm);
        }
    }

    public static void populateLocalAddresses(Set<InetAddress> set) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface nFace = interfaces.nextElement();
                if (!IgnoreException.isNetworkInterfaceUp(nFace)) continue;
                Enumeration<InetAddress> addresses = nFace.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    set.add(address);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isNetworkInterfaceUp(NetworkInterface netFace) {
        try {
            return netFace.isUp();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Charset getCharset(String charsetName) {
        try {
            return Charset.forName(charsetName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GZIPOutputStream newGZIPOutputStream(OutputStream out) {
        try {
            return new GZIPOutputStream(out, 1024);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GZIPInputStream newGZIPInputStream(InputStream in) {
        try {
            return new GZIPInputStream(in, 1024);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int transferAndClose(InputStream in, OutputStream out, int bufSize) {
        try {
            return StreamUtil.transferAndClose(in, out, bufSize);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

