/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.hash;

import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Collection;
import org.apache.niolex.commons.bean.Pair;
import org.apache.niolex.commons.codec.StringUtil;

public class DoubleHash<T> {
    private final HashFunction primary;
    private final HashFunction secondary;
    private volatile Object[] nodeArray;

    public DoubleHash(HashFunction primary, HashFunction secondary, Collection<T> nodeList) {
        this.primary = primary;
        this.secondary = secondary;
        this.nodeArray = nodeList.toArray();
    }

    public synchronized void add(T node) {
        Object[] tmpArray = new Object[this.nodeArray.length + 1];
        System.arraycopy(this.nodeArray, 0, tmpArray, 0, this.nodeArray.length);
        tmpArray[this.nodeArray.length] = node;
        this.nodeArray = tmpArray;
    }

    public synchronized void remove(T node) {
        int i;
        int length = this.nodeArray.length;
        for (i = 0; i < length && !node.equals(this.nodeArray[i]); ++i) {
        }
        if (i != length) {
            Object[] tmpArray = new Object[length - 1];
            System.arraycopy(this.nodeArray, 0, tmpArray, 0, length - 1);
            if (i != length - 1) {
                tmpArray[i] = this.nodeArray[length - 1];
            }
            this.nodeArray = tmpArray;
        }
    }

    public int size() {
        return this.nodeArray.length;
    }

    public Pair<T, T> getPairNodes(String key) {
        return this.getPairNodes(this.primary.hashString((CharSequence)key, StringUtil.UTF_8), this.secondary.hashString((CharSequence)key, StringUtil.UTF_8));
    }

    public Pair<T, T> getPairNodes(long key) {
        return this.getPairNodes(this.primary.hashLong(key), this.secondary.hashLong(key));
    }

    public Pair<T, T> getPairNodes(int key) {
        return this.getPairNodes(this.primary.hashInt(key), this.secondary.hashInt(key));
    }

    public <K> Pair<T, T> getPairNodes(K key, Funnel<? super K> funnel) {
        return this.getPairNodes(this.primary.hashObject(key, funnel), this.secondary.hashObject(key, funnel));
    }

    protected Pair<T, T> getPairNodes(HashCode primaryHashCode, HashCode secondaryHashCode) {
        Object[] tmpArray = this.nodeArray;
        int length = tmpArray.length;
        int idx1 = Hashing.consistentHash((HashCode)primaryHashCode, (int)length);
        int idx2 = Hashing.consistentHash((HashCode)secondaryHashCode, (int)(length - 1));
        if (idx2 >= idx1) {
            ++idx2;
        }
        Pair<Object, Object> r = Pair.create(tmpArray[idx1], tmpArray[idx2]);
        return r;
    }
}

