/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.hash;

import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.niolex.commons.codec.StringUtil;

public class ConsistentHash<T> {
    private final HashFunction hashFunction;
    private final int numberOfReplicas;
    private volatile TreeMap<Integer, T> circle = new TreeMap();

    public ConsistentHash() {
        this(100);
    }

    public ConsistentHash(int numberOfReplicas) {
        this(JVMHash.INSTANCE, numberOfReplicas);
    }

    public ConsistentHash(HashFunction hashFunction, int numberOfReplicas) {
        this.hashFunction = hashFunction;
        this.numberOfReplicas = numberOfReplicas;
    }

    public ConsistentHash(HashFunction hashFunction, int numberOfReplicas, Collection<T> nodes) {
        this(hashFunction, numberOfReplicas);
        this.prepare(nodes);
    }

    public void prepare(Collection<T> nodes) {
        for (T node : nodes) {
            this.internalAdd(this.circle, node);
        }
    }

    public void prepare(T ... nodes) {
        for (T node : nodes) {
            this.internalAdd(this.circle, node);
        }
    }

    public synchronized void add(T node) {
        TreeMap ring = (TreeMap)this.circle.clone();
        this.internalAdd(ring, node);
        this.circle = ring;
    }

    private void internalAdd(TreeMap<Integer, T> ring, T node) {
        int START;
        for (int i = START = this.findStart(node); i < this.numberOfReplicas + START; ++i) {
            ring.put(this.hashFunction.hashCode(node, i), node);
        }
    }

    public synchronized void remove(T node) {
        int START;
        TreeMap ring = (TreeMap)this.circle.clone();
        for (int i = START = this.findStart(node); i < this.numberOfReplicas + START; ++i) {
            ring.remove(this.hashFunction.hashCode(node, i));
        }
        this.circle = ring;
    }

    private int findStart(T node) {
        int START = this.hashFunction.hashCode(node);
        return START > Integer.MAX_VALUE - this.numberOfReplicas ? START - this.numberOfReplicas * 79 : START;
    }

    public T getNode(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hash = this.hashFunction.hashCode(key);
        Map.Entry<Integer, T> en = this.circle.ceilingEntry(hash);
        en = en == null ? this.circle.firstEntry() : en;
        return en.getValue();
    }

    public List<T> getNodeList(Object key) {
        return this.getNodeList(key, 2);
    }

    public List<T> getNodeList(Object key, int numberOfNodes) {
        HashSet<T> set = new HashSet<T>(numberOfNodes);
        ArrayList<T> list = new ArrayList<T>(numberOfNodes);
        if (this.circle.isEmpty()) {
            return list;
        }
        int hash = this.hashFunction.hashCode(key);
        SortedMap<Integer, T> tail = this.circle.tailMap(hash);
        Iterator<T> iter = tail.values().iterator();
        boolean isTail = true;
        while (set.size() < numberOfNodes) {
            if (iter.hasNext()) {
                T t = iter.next();
                if (!set.add(t)) continue;
                list.add(t);
                continue;
            }
            if (isTail) {
                iter = this.circle.values().iterator();
                isTail = false;
                continue;
            }
            throw new IllegalStateException("There are only " + set.size() + " different nodes, but request " + numberOfNodes + " in total.");
        }
        return list;
    }

    public static class GuavaHash
    implements HashFunction {
        public static final GuavaHash INSTANCE = new GuavaHash();

        @Override
        public int hashCode(Object o) {
            return Hashing.murmur3_32().hashString((CharSequence)o.toString(), StringUtil.UTF_8).asInt();
        }

        @Override
        public int hashCode(Object o, int seed) {
            return Hashing.murmur3_32((int)seed).hashString((CharSequence)o.toString(), StringUtil.UTF_8).asInt();
        }
    }

    public static class JVMHash
    implements HashFunction {
        public static final JVMHash INSTANCE = new JVMHash();

        @Override
        public int hashCode(Object o) {
            return o.hashCode();
        }

        @Override
        public int hashCode(Object o, int seed) {
            StringBuilder sb = new StringBuilder();
            sb.append(seed).append(o).append(seed);
            return sb.toString().hashCode();
        }
    }

    public static interface HashFunction {
        public int hashCode(Object var1);

        public int hashCode(Object var1, int var2);
    }
}

