/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.file;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.niolex.commons.concurrent.SimpleThreadFactory;

public class FileMonitor
implements Runnable {
    protected static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(1, new SimpleThreadFactory("file-monitor"));
    protected final int monitorInterval;
    protected final String filePathName;
    protected final List<EventListener> list = Lists.newArrayList();
    protected final ScheduledFuture<?> holder;
    protected File file;
    protected boolean fileExists;
    protected long lastModified;

    public FileMonitor(int monitorInterval, String filePathName) {
        this.monitorInterval = monitorInterval;
        this.filePathName = filePathName;
        this.file = new File(filePathName);
        this.holder = EXECUTOR.scheduleWithFixedDelay(this, 1L, monitorInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void run() {
        if (!this.file.exists()) {
            if (this.fileExists) {
                this.fileExists = false;
                this.notifyListeners(EventType.DELETE, -1L);
            }
            return;
        }
        long time = this.file.lastModified();
        if (!this.fileExists) {
            this.fileExists = true;
            this.notifyListeners(EventType.CREATE, time);
            this.lastModified = time;
        }
        if (this.lastModified < time) {
            this.notifyListeners(EventType.UPDATE, time);
            this.lastModified = time;
        }
    }

    protected synchronized void notifyListeners(EventType type, long happenTime) {
        for (EventListener li : this.list) {
            li.notify(type, happenTime);
        }
    }

    public synchronized void addListener(EventListener li) {
        this.list.add(li);
    }

    public synchronized boolean removeListener(EventListener li) {
        return this.list.remove(li);
    }

    public void stop() {
        this.holder.cancel(false);
    }

    public static interface EventListener {
        public void notify(EventType var1, long var2);
    }

    public static enum EventType {
        CREATE,
        DELETE,
        UPDATE,
        ADD_CHILDREN,
        REMOVE_CHILDREN,
        NOT_DIR;

    }
}

