/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.event;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.niolex.commons.concurrent.ConcurrentUtil;
import org.apache.niolex.commons.event.BaseEvent;
import org.apache.niolex.commons.event.Dispatcher;
import org.apache.niolex.commons.event.Event;
import org.apache.niolex.commons.event.EventUtil;
import org.apache.niolex.commons.event.Listener;

public class ConcurrentEventDispatcher
implements Dispatcher {
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<Listener<?>>> handlerMap = new ConcurrentHashMap();

    @Override
    public void addListener(Class<?> eventType, Listener<?> eListener) {
        this.addListener(eventType.getName(), eListener);
    }

    @Override
    public void addListener(String eventType, Listener<?> eListener) {
        ConcurrentLinkedQueue<Listener<Object>> queue = this.handlerMap.get(eventType);
        if (queue == null) {
            queue = ConcurrentUtil.initMap(this.handlerMap, eventType, new ConcurrentLinkedQueue());
        }
        queue.add(eListener);
    }

    @Override
    public void removeListener(Class<?> eventType, Listener<?> eListener) {
        this.removeListener(eventType.getName(), eListener);
    }

    @Override
    public void removeListener(String eventType, Listener<?> eListener) {
        ConcurrentLinkedQueue<Listener<?>> queue = this.handlerMap.get(eventType);
        if (queue != null) {
            queue.remove(eListener);
        }
    }

    public void internalFireEvent(Event<?> e) {
        ConcurrentLinkedQueue<Listener<?>> queue = this.handlerMap.get(e.getEventType());
        if (queue != null) {
            for (Listener<?> l : queue) {
                EventUtil.dispatch(l, e);
            }
        }
    }

    @Override
    public void fireEvent(Object e) {
        if (e instanceof Event) {
            this.internalFireEvent((Event)e);
        } else {
            this.internalFireEvent(BaseEvent.create(e));
        }
    }
}

