/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.control;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.niolex.commons.control.FrequencyCheck;

public class TimeCheck {
    final AtomicInteger counter = new AtomicInteger();
    final int intervalTime;
    final int intervalCnt;
    final FrequencyCheck freqCheck;
    volatile boolean lastCheckStatus;
    volatile long lastCheckTime;

    public TimeCheck(int checkInterval, int splitCnt, int totalNum) {
        this.intervalTime = checkInterval / splitCnt;
        this.intervalCnt = totalNum / splitCnt;
        this.freqCheck = new FrequencyCheck(splitCnt, totalNum);
        this.lastCheckStatus = true;
        this.lastCheckTime = System.currentTimeMillis();
    }

    public boolean check() {
        long t = System.currentTimeMillis();
        if (t - this.lastCheckTime >= (long)this.intervalTime) {
            this.checkIntervalCnt(t);
        }
        if (this.lastCheckStatus) {
            this.counter.incrementAndGet();
            return true;
        }
        if (this.counter.get() < this.intervalCnt) {
            this.counter.incrementAndGet();
            return true;
        }
        return false;
    }

    public synchronized void checkIntervalCnt(long time) {
        if (time - this.lastCheckTime >= (long)this.intervalTime) {
            this.lastCheckTime = time;
            this.lastCheckStatus = this.freqCheck.check(this.counter.getAndSet(0));
        }
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public boolean lastCheckStatus() {
        return this.lastCheckStatus;
    }

    public long getLastCheckTime() {
        return this.lastCheckTime;
    }
}

