/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.config;

import java.io.IOException;
import org.apache.niolex.commons.config.PropertiesWrapper;
import org.apache.niolex.commons.file.FileMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadablePropertiesWrapper
extends PropertiesWrapper
implements FileMonitor.EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadablePropertiesWrapper.class);
    private static final long serialVersionUID = -2353322837021805417L;
    private final FileMonitor monitor;
    private final String fileName;

    public ReloadablePropertiesWrapper(String fileName, int monitorInterval) throws IOException {
        super(fileName);
        this.fileName = fileName;
        this.monitor = new FileMonitor(monitorInterval, fileName);
        this.monitor.addListener(this);
    }

    @Override
    public void notify(FileMonitor.EventType type, long happenTime) {
        if (type == FileMonitor.EventType.UPDATE) {
            try {
                this.load(this.fileName);
                LOG.debug("Properties file refreshed: {}", (Object)this.fileName);
            }
            catch (IOException e) {
                LOG.warn("Failed to read config file: {}", (Object)this.fileName, (Object)e);
            }
        }
    }

    public void stopRefresh() {
        this.monitor.removeListener(this);
        this.monitor.stop();
    }
}

