/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.niolex.commons.concurrent.BlockerException;

public class WaitOn<E> {
    private final CountDownLatch latch;
    private volatile E result;
    private volatile BlockerException exc;

    public WaitOn(CountDownLatch latch) {
        this.latch = latch;
    }

    public E waitForResult(long time) throws InterruptedException, BlockerException {
        if (this.result != null) {
            return this.result;
        }
        if (this.exc != null) {
            throw this.exc;
        }
        this.latch.await(time, TimeUnit.MILLISECONDS);
        if (this.exc != null) {
            throw this.exc;
        }
        return this.result;
    }

    public void release(E result) {
        this.result = result;
        this.latch.countDown();
    }

    public void release(BlockerException exc) {
        this.exc = exc;
        this.latch.countDown();
    }
}

