/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class ThreadUtil {
    public static final ThreadGroup topGroup() {
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        for (ThreadGroup pareGroup = topGroup.getParent(); pareGroup != null; pareGroup = pareGroup.getParent()) {
            topGroup = pareGroup;
        }
        return topGroup;
    }

    public static final List<Thread> getAllThreads() {
        ThreadGroup topGroup = ThreadUtil.topGroup();
        return ThreadUtil.getAllThreadsInGroup(topGroup, topGroup.activeCount());
    }

    public static final List<Thread> getAllThreadsInGroup(ThreadGroup group, int size) {
        Thread[] array = null;
        while ((size = group.enumerate(array = new Thread[size + 100], true)) >= array.length) {
        }
        ArrayList<Thread> ret = new ArrayList<Thread>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(array[i]);
        }
        return ret;
    }

    public static final void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void sleepAtLeast(long milliseconds) {
        long in = System.currentTimeMillis();
        long t = 0L;
        do {
            ThreadUtil.sleep(milliseconds - t);
        } while ((t = System.currentTimeMillis() - in) < milliseconds);
    }

    public static final boolean join(Thread thread) {
        try {
            thread.join();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final boolean waitFor(CountDownLatch latch) {
        try {
            latch.await();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

