/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.concurrent;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.niolex.commons.concurrent.SimpleFuture;

public class InvokableExecutorService
implements ExecutorService {
    private final ExecutorService pool;

    public InvokableExecutorService(ExecutorService pool) {
        this.pool = pool;
    }

    public <V> Future<V> invoke(Object host, Method method, Object ... args) {
        SimpleFuture fu = new SimpleFuture();
        Invoker inv = new Invoker(method, host, args, fu);
        this.submit(inv);
        return fu;
    }

    @Override
    public void execute(Runnable command) {
        this.pool.execute(command);
    }

    @Override
    public void shutdown() {
        this.pool.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.pool.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.pool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.pool.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pool.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.pool.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.pool.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.pool.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.pool.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.pool.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.pool.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.pool.invokeAny(tasks, timeout, unit);
    }

    private static class Invoker<V>
    implements Runnable {
        private final Method method;
        private final Object host;
        private final Object[] args;
        private final SimpleFuture<V> fu;

        public Invoker(Method method, Object host, Object[] args, SimpleFuture<V> fu) {
            this.method = method;
            this.host = host;
            this.args = args;
            this.fu = fu;
        }

        @Override
        public void run() {
            try {
                Object ret = this.method.invoke(this.host, this.args);
                this.fu.setDone(ret);
            }
            catch (Throwable t) {
                this.fu.setAbort(t);
            }
        }
    }
}

