/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ConcurrentUtil {
    public static final <K, V> V initMap(ConcurrentMap<K, V> map, K key, V newValue) {
        V oldValue = map.putIfAbsent(key, newValue);
        return oldValue == null ? newValue : oldValue;
    }

    public static final void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        while (true) {
            try {
                while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static final void shutdownAndAwaitTermination(ExecutorService pool, long timeout, TimeUnit unit) {
        pool.shutdown();
        long start = System.currentTimeMillis();
        timeout = unit.toMillis(timeout);
        block2: while (true) {
            try {
                long remain;
                do {
                    remain = System.currentTimeMillis() - start;
                    if ((remain = timeout - remain) >= 1L) continue;
                    pool.shutdownNow();
                    break block2;
                } while (!pool.awaitTermination(remain, TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

