/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.concurrent;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.niolex.commons.concurrent.BlockerException;
import org.apache.niolex.commons.concurrent.ConcurrentUtil;
import org.apache.niolex.commons.concurrent.WaitOn;

public class Blocker<E> {
    private final ConcurrentHashMap<Object, WaitOn<E>> waitMap = new ConcurrentHashMap();

    public WaitOn<E> init(Object key) {
        WaitOn<E> w = this.waitMap.get(key);
        if (w == null) {
            w = ConcurrentUtil.initMap(this.waitMap, key, new WaitOn(new CountDownLatch(1)));
        }
        return w;
    }

    public E waitForResult(Object key, long time) throws InterruptedException, BlockerException {
        return this.init(key).waitForResult(time);
    }

    public boolean release(Object key, E value) {
        WaitOn<E> it = this.waitMap.remove(key);
        if (it != null) {
            it.release(value);
            return true;
        }
        return false;
    }

    public boolean release(Object key, BlockerException ex) {
        WaitOn<E> it = this.waitMap.remove(key);
        if (it != null) {
            it.release(ex);
            return true;
        }
        return false;
    }

    public void releaseAll() {
        Iterator<WaitOn<E>> iter = this.waitMap.values().iterator();
        BlockerException e = new BlockerException("User triggered release all.");
        while (iter.hasNext()) {
            iter.next().release(e);
        }
        this.waitMap.clear();
    }
}

