/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.concurrent;

import java.util.concurrent.CountDownLatch;
import org.apache.niolex.commons.concurrent.ThreadUtil;

public class BlockThread
extends Thread {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final int sleepTime;

    public BlockThread() {
        this.sleepTime = 0;
    }

    public BlockThread(String name) {
        super(name);
        this.sleepTime = 0;
    }

    public BlockThread(String name, int sleepTime) {
        super(name);
        this.sleepTime = sleepTime;
    }

    @Override
    public synchronized void start() {
        super.start();
        ThreadUtil.waitFor(this.latch);
    }

    @Override
    public final void run() {
        this.latch.countDown();
        if (this.sleepTime > 0) {
            ThreadUtil.sleep(this.sleepTime);
        }
        this.run0();
    }

    public void run0() {
        super.run();
    }
}

