/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.niolex.commons.compress.AbstractCompressor;
import org.apache.niolex.commons.internal.IgnoreException;
import org.apache.niolex.commons.stream.StreamUtil;

public class GZiper
extends AbstractCompressor {
    @Override
    public byte[] compress(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream zout = IgnoreException.newGZIPOutputStream(out);
        StreamUtil.writeAndCloseIgnoreException(zout, data);
        return out.toByteArray();
    }

    @Override
    public byte[] decompress(byte[] data) {
        GZIPInputStream zin = IgnoreException.newGZIPInputStream(new ByteArrayInputStream(data));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IgnoreException.transferAndClose(zin, out, 10240);
        return out.toByteArray();
    }
}

