/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.collection;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.niolex.commons.collection.Cache;

public class SegmentLFUCache<K, V>
implements Cache<K, V> {
    protected static final int MAX_SEGMENTS = 16384;
    protected static final int MIN_TABLE_ITEM = 128;
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger nextVictimSegment = new AtomicInteger();
    private final int maxSize;
    private final Segment<K, V>[] segmentTable;
    private final int segmentMask;
    private final int segmentShift;

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    private final Segment<K, V> segmentFor(int hash) {
        return this.segmentTable[hash >>> this.segmentShift & this.segmentMask];
    }

    public SegmentLFUCache(int maxSize, int concurrencyLevel) {
        int ssize;
        if (concurrencyLevel > 16384) {
            concurrencyLevel = 16384;
        } else if (concurrencyLevel < 16) {
            concurrencyLevel = 16;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        int emax = (int)((double)maxSize / ((double)ssize * 0.75)) + 1;
        int esize = 128;
        if (emax < esize) {
            throw new IllegalArgumentException("The parameter 'maxSize' must greater than " + ssize * esize);
        }
        while (esize < emax) {
            esize <<= 1;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.maxSize = maxSize;
        this.segmentTable = new Segment[ssize];
        for (int i = 0; i < ssize; ++i) {
            this.segmentTable[i] = new Segment(esize);
        }
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public V get(K key) {
        if (key == null) {
            throw new NullPointerException("The parameter 'key' should not be null.");
        }
        int hash = SegmentLFUCache.hash(key.hashCode());
        ItemEntry<K, V> e = this.segmentFor(hash).findItem(hash, key);
        if (e != null) {
            ++((ItemEntry)e).visits;
            return (V)((ItemEntry)e).value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("The parameter 'key' should not be null.");
        }
        if (value == null) {
            throw new NullPointerException("The parameter 'value' should not be null.");
        }
        int hash = SegmentLFUCache.hash(key.hashCode());
        V v = this.segmentFor(hash).put(hash, key, value);
        if (v == null && this.size.incrementAndGet() > this.maxSize) {
            int idx;
            Segment<K, V> s;
            int delta = 0;
            while ((delta = (s = this.segmentTable[(idx = this.nextVictimSegment.getAndIncrement()) & this.segmentMask]).eviction()) == 0) {
            }
            this.size.addAndGet(-delta);
        }
        return v;
    }

    @Override
    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException("The parameter 'key' should not be null.");
        }
        int hash = SegmentLFUCache.hash(key.hashCode());
        V v = this.segmentFor(hash).remove(hash, key);
        if (v != null) {
            this.size.decrementAndGet();
        }
        return v;
    }

    protected static class Segment<K, V> {
        private final Lock w = new ReentrantLock();
        private final ItemEntry<K, V>[] table;
        private final ItemEntry<K, V> LFUHead;
        private final int entryMask;
        private volatile int itemSize;

        public Segment(int entrySize) {
            if ((entrySize & entrySize - 1) != 0) {
                throw new IllegalArgumentException("Invlid entry size.");
            }
            this.itemSize = 0;
            this.entryMask = entrySize - 1;
            this.table = new ItemEntry[entrySize];
            for (int i = 0; i < entrySize; ++i) {
                this.table[i] = new ItemEntry();
            }
            this.LFUHead = new ItemEntry();
            ((ItemEntry)this.LFUHead).linkPrev = (((ItemEntry)this.LFUHead).linkNext = (ItemEntry)this.LFUHead);
        }

        protected final ItemEntry<K, V> entryFor(int hash) {
            return this.table[hash & this.entryMask];
        }

        protected ItemEntry<K, V> findItem(int hash, K key) {
            ItemEntry<K, V> head = this.entryFor(hash);
            ItemEntry e = ((ItemEntry)head).mapNext;
            while (e != head) {
                Object k;
                if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                    return e;
                }
                e = e.mapNext;
            }
            return null;
        }

        protected final void addNewItemUnderLock(int hash, K key, V value) {
            ItemEntry<K, V> head = this.entryFor(hash);
            ItemEntry<K, V> e = new ItemEntry<K, V>(key, value, hash);
            ((ItemEntry)e).mapPrev = (ItemEntry)head;
            ((ItemEntry)e).mapNext = ((ItemEntry)head).mapNext;
            ((ItemEntry)head).mapNext.mapPrev = (ItemEntry)e;
            ((ItemEntry)head).mapNext = (ItemEntry)e;
            this.addItemIntoLinkAfterThisUnderLock(e, this.LFUHead);
            ++this.itemSize;
        }

        protected final void addItemIntoLinkAfterThisUnderLock(ItemEntry<K, V> e, ItemEntry<K, V> after) {
            ((ItemEntry)e).linkPrev = (ItemEntry)after;
            ((ItemEntry)e).linkNext = ((ItemEntry)after).linkNext;
            ((ItemEntry)after).linkNext.linkPrev = (ItemEntry)e;
            ((ItemEntry)after).linkNext = (ItemEntry)e;
        }

        protected final void removeItemFromMapUnderLock(ItemEntry<K, V> e) {
            ((ItemEntry)e).mapPrev.mapNext = ((ItemEntry)e).mapNext;
            ((ItemEntry)e).mapNext.mapPrev = ((ItemEntry)e).mapPrev;
            --this.itemSize;
        }

        protected final void removeItemFromLinkUnderLock(ItemEntry<K, V> e) {
            ((ItemEntry)e).linkPrev.linkNext = ((ItemEntry)e).linkNext;
            ((ItemEntry)e).linkNext.linkPrev = ((ItemEntry)e).linkPrev;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V put(int hash, K key, V value) {
            this.w.lock();
            try {
                ItemEntry<K, V> e = this.findItem(hash, key);
                if (e == null) {
                    this.addNewItemUnderLock(hash, key, value);
                    V v = null;
                    return v;
                }
                Object old_value = ((ItemEntry)e).value;
                ++((ItemEntry)e).visits;
                ((ItemEntry)e).value = value;
                Object object = old_value;
                return (V)object;
            }
            finally {
                this.w.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V remove(int hash, K key) {
            this.w.lock();
            try {
                ItemEntry<K, V> e = this.findItem(hash, key);
                if (e == null) {
                    V v = null;
                    return v;
                }
                this.removeItemFromMapUnderLock(e);
                this.removeItemFromLinkUnderLock(e);
                Object object = ((ItemEntry)e).value;
                return (V)object;
            }
            finally {
                this.w.unlock();
            }
        }

        protected int size() {
            return this.itemSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int eviction() {
            this.w.lock();
            try {
                ItemEntry tail = ((ItemEntry)this.LFUHead).linkPrev;
                int batchSize = this.itemSize / 3 + 3;
                int visits = 0;
                while (tail != this.LFUHead) {
                    if (++visits > batchSize) {
                        this.removeItemFromLinkUnderLock(this.LFUHead);
                        this.addItemIntoLinkAfterThisUnderLock(this.LFUHead, tail);
                        int n = 0;
                        return n;
                    }
                    if (--tail.visits <= 0) {
                        this.removeItemFromMapUnderLock(tail);
                        if (tail.linkNext == this.LFUHead) {
                            this.removeItemFromLinkUnderLock(tail);
                        } else {
                            this.removeItemFromLinkUnderLock(this.LFUHead);
                            ((ItemEntry)this.LFUHead).linkPrev = tail.linkPrev;
                            ((ItemEntry)this.LFUHead).linkNext = tail.linkNext;
                            tail.linkPrev.linkNext = (ItemEntry)this.LFUHead;
                            tail.linkNext.linkPrev = (ItemEntry)this.LFUHead;
                        }
                        int n = 1;
                        return n;
                    }
                    tail = tail.linkPrev;
                }
            }
            finally {
                this.w.unlock();
            }
            return 0;
        }
    }

    protected static class ItemEntry<K, V> {
        private final int hash;
        private final K key;
        private volatile V value;
        private volatile int visits;
        private ItemEntry<K, V> mapPrev;
        private volatile ItemEntry<K, V> mapNext;
        private ItemEntry<K, V> linkPrev;
        private ItemEntry<K, V> linkNext;

        public ItemEntry() {
            this.key = null;
            this.value = null;
            this.hash = -1;
            this.visits = 0;
            this.mapPrev = this.mapNext = this;
            this.linkNext = null;
            this.linkPrev = null;
        }

        public ItemEntry(K key, V value, int hash) {
            this.key = key;
            this.hash = hash;
            this.visits = 1;
            this.value = value;
        }
    }
}

