/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

@Deprecated
public class RetainLinkedList<E> {
    private final int retainSize;
    private final AtomicInteger size = new AtomicInteger(0);
    private final ReentrantLock headLock = new ReentrantLock();
    private final ReentrantLock tailLock = new ReentrantLock();
    private final Link<E> head = new Link<Object>(null);
    private transient Link<E> pointer = this.head;
    private transient Link<E> tail = this.head;
    private transient int headPointerSize = 0;

    public RetainLinkedList(int retainSize) {
        if (retainSize < 1) {
            throw new IllegalArgumentException("retainSize must greater than 0");
        }
        this.retainSize = retainSize;
    }

    public void add(E e) {
        this.tailLock.lock();
        try {
            ((Link)this.tail).next = (Link)new Link<E>(e);
            this.tail = ((Link)this.tail).next;
            this.size.incrementAndGet();
        }
        finally {
            this.tailLock.unlock();
        }
    }

    public boolean hasNext() {
        return ((Link)this.pointer).next != null;
    }

    public E handleNext() {
        this.headLock.lock();
        try {
            if (((Link)this.pointer).next == null) {
                E e = null;
                return e;
            }
            this.pointer = ((Link)this.pointer).next;
            if (this.headPointerSize >= this.retainSize) {
                Link t = ((Link)this.head).next;
                ((Link)this.head).next = t.next;
                t.next = null;
                this.size.decrementAndGet();
            } else {
                ++this.headPointerSize;
            }
            Object object = ((Link)this.pointer).e;
            return (E)object;
        }
        finally {
            this.headLock.unlock();
        }
    }

    public boolean hasRetain() {
        return this.headPointerSize != 0;
    }

    public E handleRetain() {
        this.headLock.lock();
        try {
            if (this.headPointerSize == 0) {
                E e = null;
                return e;
            }
            Link tmp = ((Link)this.head).next;
            --this.headPointerSize;
            ((Link)this.head).next = tmp.next;
            tmp.next = null;
            this.size.decrementAndGet();
            Object object = tmp.e;
            return (E)object;
        }
        finally {
            this.headLock.unlock();
        }
    }

    public void addAll(RetainLinkedList<E> other) {
        E e;
        while ((e = other.handleNext()) != null) {
            this.add(e);
        }
    }

    public void addAll(Collection<E> other) {
        Iterator<E> it = other.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E[] toArray(E[] a) {
        this.headLock.lock();
        try {
            int len = this.size.intValue();
            if (a.length < len) {
                len = a.length;
            }
            Link tmp = ((Link)this.head).next;
            for (int i = 0; i < len; ++i) {
                a[i] = tmp.e;
                tmp = tmp.next;
            }
            E[] EArray = a;
            return EArray;
        }
        finally {
            this.headLock.unlock();
        }
    }

    public int totalSize() {
        return this.size.intValue();
    }

    public int handleSize() {
        return this.size.intValue() - this.headPointerSize;
    }

    private static class Link<E> {
        private final E e;
        private Link<E> next;

        public Link(E e) {
            this.e = e;
        }
    }
}

