/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.collection;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.niolex.commons.collection.Cache;
import org.apache.niolex.commons.test.Check;

public class ConcurrentLRUCache<K, V>
implements Cache<K, V> {
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger visitTime = new AtomicInteger();
    private final ThreeQLRUList<K, V> lruList = new ThreeQLRUList();
    private final int maxSize;
    private final int entrySize;
    private final int victimSize;
    private final TableEntry<K, V>[] table;

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h > 0 ? h % length : -(h % length);
    }

    public ConcurrentLRUCache(int maxSize) {
        Check.lt(50, maxSize, "The parameter 'maxSize' must greater than 50.");
        this.maxSize = maxSize;
        this.entrySize = (int)((double)maxSize / 0.75);
        this.victimSize = (maxSize - 4) / 3;
        this.table = new TableEntry[this.entrySize];
        for (int i = 0; i < this.entrySize; ++i) {
            this.table[i] = new TableEntry();
        }
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public V get(K key) {
        if (key == null) {
            throw new NullPointerException("The parameter 'key' should not be null.");
        }
        int hash = ConcurrentLRUCache.hash(key.hashCode());
        TableEntry<K, V> en = this.table[ConcurrentLRUCache.indexFor(hash, this.entrySize)];
        ItemEntry<K, V> e = this.findItemFromMapEntry(en, hash, key);
        if (e != null) {
            ((ItemEntry)e).lastVisitAt = System.currentTimeMillis();
            this.addVisit();
            return (V)((ItemEntry)e).value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("The parameter 'key' should not be null.");
        }
        if (value == null) {
            throw new NullPointerException("The parameter 'value' should not be null.");
        }
        int hash = ConcurrentLRUCache.hash(key.hashCode());
        TableEntry<K, V> en = this.table[ConcurrentLRUCache.indexFor(hash, this.entrySize)];
        ItemEntry<K, V> e = null;
        ((TableEntry)en).w.lock();
        try {
            e = this.findItemFromMapEntry(en, hash, key);
            if (e != null) {
                this.addVisit();
                ((ItemEntry)e).lastVisitAt = System.currentTimeMillis();
                Object o = ((ItemEntry)e).value;
                ((ItemEntry)e).value = value;
                Object object = o;
                return (V)object;
            }
            e = new ItemEntry();
            ((ItemEntry)e).key = key;
            ((ItemEntry)e).lastVisitAt = System.currentTimeMillis();
            ((ItemEntry)e).hash = hash;
            ((ItemEntry)e).value = value;
            this.lruList.addEntry(e);
            ((ItemEntry)e).mapNext = ((TableEntry)en).head;
            ((ItemEntry)e).mapPrev = null;
            if (((TableEntry)en).head != null) {
                ((TableEntry)en).head.mapPrev = (ItemEntry)e;
            }
            ((TableEntry)en).head = e;
        }
        finally {
            ((TableEntry)en).w.unlock();
        }
        this.addVisit();
        if (this.size.incrementAndGet() > this.maxSize && (e = this.lruList.findVictim(this.victimSize)) != null) {
            int h2 = ConcurrentLRUCache.hash(((ItemEntry)e).key.hashCode());
            en = this.table[ConcurrentLRUCache.indexFor(h2, this.entrySize)];
            ((TableEntry)en).w.lock();
            try {
                if (((TableEntry)en).head == e || ((ItemEntry)e).mapPrev.mapNext == e) {
                    this.removeEntryFromMap(en, e);
                    this.size.decrementAndGet();
                }
            }
            finally {
                ((TableEntry)en).w.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException("The parameter 'key' should not be null.");
        }
        int hash = ConcurrentLRUCache.hash(key.hashCode());
        TableEntry<K, V> en = this.table[ConcurrentLRUCache.indexFor(hash, this.entrySize)];
        ((TableEntry)en).w.lock();
        try {
            ItemEntry<K, V> e2 = this.findItemFromMapEntry(en, hash, key);
            if (e2 != null) {
                this.removeEntryFromMap(en, e2);
                this.lruList.removeEntry(e2);
                this.size.decrementAndGet();
                Object object = ((ItemEntry)e2).value;
                return (V)object;
            }
        }
        finally {
            ((TableEntry)en).w.unlock();
        }
        return null;
    }

    protected void removeEntryFromMap(TableEntry<K, V> en, ItemEntry<K, V> e2) {
        if (((ItemEntry)e2).mapPrev == null) {
            ((TableEntry)en).head = ((ItemEntry)e2).mapNext;
        } else {
            ((ItemEntry)e2).mapPrev.mapNext = ((ItemEntry)e2).mapNext;
        }
        if (((ItemEntry)e2).mapNext != null) {
            ((ItemEntry)e2).mapNext.mapPrev = ((ItemEntry)e2).mapPrev;
        }
    }

    protected ItemEntry<K, V> findItemFromMapEntry(TableEntry<K, V> en, int hash, K key) {
        ItemEntry e = ((TableEntry)en).head;
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                return e;
            }
            e = e.mapNext;
        }
        return null;
    }

    protected void addVisit() {
        if (this.visitTime.incrementAndGet() == this.victimSize) {
            this.visitTime.set(0);
            this.lruList.pushHeaderTime(System.currentTimeMillis());
        }
    }

    protected static class ThreeQLRUList<K, V> {
        private final Lock linkLock = new ReentrantLock();
        private int walkThroughSize = 0;
        private ItemEntry<K, V> head = null;
        private ItemEntry<K, V> tail = null;
        private volatile long lastRoundHeaderTime = 0L;
        private volatile long middleRoundHeaderTime = 0L;
        private volatile long firstRoundHeaderTime = 0L;

        protected ThreeQLRUList() {
        }

        public void pushHeaderTime(long time) {
            this.lastRoundHeaderTime = this.middleRoundHeaderTime;
            this.middleRoundHeaderTime = this.firstRoundHeaderTime;
            this.firstRoundHeaderTime = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ItemEntry<K, V> findVictim(int victimSize) {
            this.linkLock.lock();
            try {
                ItemEntry cur = this.tail;
                long time = this.lastRoundHeaderTime;
                while (cur != null) {
                    if (cur.lastVisitAt <= time) {
                        if (cur != this.tail) {
                            ((ItemEntry)this.tail).linkNext = (ItemEntry)this.head;
                            ((ItemEntry)this.head).linkPrev = (ItemEntry)this.tail;
                            this.head = cur.linkNext;
                            cur.linkNext.linkPrev = null;
                        }
                        this.tail = cur.linkPrev;
                        cur.linkPrev.linkNext = null;
                        cur.linkPrev = (cur.linkNext = null);
                        ItemEntry itemEntry = cur;
                        return itemEntry;
                    }
                    ++this.walkThroughSize;
                    if (this.walkThroughSize >= victimSize) {
                        this.walkThroughSize = 0;
                        this.pushHeaderTime(cur.lastVisitAt);
                        time = this.lastRoundHeaderTime;
                    }
                    cur = cur.linkPrev;
                }
                ItemEntry<K, V> itemEntry = null;
                return itemEntry;
            }
            finally {
                this.linkLock.unlock();
            }
        }

        public void addEntry(ItemEntry<K, V> cur) {
            this.linkLock.lock();
            try {
                ((ItemEntry)cur).linkPrev = null;
                ((ItemEntry)cur).linkNext = (ItemEntry)this.head;
                if (this.head != null) {
                    ((ItemEntry)this.head).linkPrev = (ItemEntry)cur;
                }
                this.head = cur;
                if (this.tail == null) {
                    this.tail = cur;
                }
            }
            finally {
                this.linkLock.unlock();
            }
        }

        public void removeEntry(ItemEntry<K, V> cur) {
            this.linkLock.lock();
            try {
                if (((ItemEntry)cur).linkPrev == null && ((ItemEntry)cur).linkNext == null) {
                    if (cur == this.head) {
                        this.tail = null;
                        this.head = null;
                    }
                    return;
                }
                if (cur == this.head) {
                    this.head = ((ItemEntry)cur).linkNext;
                    ((ItemEntry)this.head).linkPrev = null;
                } else if (cur == this.tail) {
                    this.tail = ((ItemEntry)cur).linkPrev;
                    ((ItemEntry)this.tail).linkNext = null;
                } else {
                    ((ItemEntry)cur).linkNext.linkPrev = ((ItemEntry)cur).linkPrev;
                    ((ItemEntry)cur).linkPrev.linkNext = ((ItemEntry)cur).linkNext;
                }
                ((ItemEntry)cur).linkPrev = (((ItemEntry)cur).linkNext = null);
            }
            finally {
                this.linkLock.unlock();
            }
        }
    }

    protected static class TableEntry<K, V> {
        private final Lock w = new ReentrantLock();
        private volatile ItemEntry<K, V> head = null;

        protected TableEntry() {
        }
    }

    protected static class ItemEntry<K, V> {
        private K key;
        private volatile V value;
        private int hash;
        private long lastVisitAt;
        private ItemEntry<K, V> mapPrev;
        private volatile ItemEntry<K, V> mapNext;
        private ItemEntry<K, V> linkPrev;
        private ItemEntry<K, V> linkNext;

        protected ItemEntry() {
        }
    }
}

