/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.coder;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.niolex.commons.codec.Base64Util;
import org.apache.niolex.commons.coder.BaseCoder;

public class TripleDESCoder
extends BaseCoder {
    public static final String ALGORITHM = "DESede";
    public static final String TRANSFORMATION = "DESede/CBC/ISO10126Padding";
    private Key secretKey;
    private IvParameterSpec ivParam;

    @Override
    public void initKey(String key) {
        byte[] keyData = Base64Util.base64ToByte(key);
        this.ivParam = new IvParameterSpec(keyData, 0, 8);
        try {
            DESedeKeySpec keySpec = new DESedeKeySpec(keyData, keyData.length - 24);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            this.secretKey = keyFactory.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to init this key.", e);
        }
    }

    @Override
    public byte[] internalEncrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, this.secretKey, this.ivParam);
        return cipher.doFinal(data);
    }

    @Override
    public byte[] internalDecrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, this.secretKey, this.ivParam);
        return cipher.doFinal(data);
    }
}

