/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.coder;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.niolex.commons.codec.Base64Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(KeyUtil.class);
    public static final int DEFAULT_IV = 128;

    public static KeyGenerator getKeyGenerator(String algorithm) {
        try {
            return KeyGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Algorithm not found for: " + algorithm, e);
        }
    }

    public static String genKey(String algorithm) {
        return KeyUtil.genKey(null, algorithm, 128, 0);
    }

    public static String genKey(String algorithm, int ivSize, int keySize) {
        return KeyUtil.genKey(null, algorithm, ivSize, keySize);
    }

    public static String genKey(String seed, String algorithm, int ivSize, int keySize) {
        LOG.info("Start to generate key for {}; the current seed is set to: {}.", (Object)algorithm, (Object)seed);
        SecureRandom secureRandom = null;
        int ivLength = ivSize / 8;
        if (seed != null) {
            secureRandom = new SecureRandom(Base64Util.base64ToByte(seed));
        } else {
            secureRandom = new SecureRandom();
            secureRandom.setSeed(System.nanoTime());
        }
        KeyGenerator kg = KeyUtil.getKeyGenerator(algorithm);
        if (keySize <= 0) {
            kg.init(secureRandom);
        } else {
            kg.init(keySize, secureRandom);
        }
        SecretKey key = kg.generateKey();
        byte[] secretKey = key.getEncoded();
        int keyLength = secretKey.length;
        LOG.info("Secret key for {} generated; key class: {}, key length: {}bits.", new Object[]{algorithm, key.getClass().getName(), keyLength * 8});
        byte[] keyBytes = new byte[ivLength + keyLength];
        secureRandom.nextBytes(keyBytes);
        System.arraycopy(secretKey, 0, keyBytes, ivLength, keyLength);
        String curKey = Base64Util.byteToBase64(keyBytes);
        LOG.debug("The generate key is: {}.", (Object)curKey);
        return curKey;
    }
}

