/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.coder;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.niolex.commons.codec.Base64Util;
import org.apache.niolex.commons.coder.BaseCoder;

public class AESCoder
extends BaseCoder {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/CBC/ISO10126Padding";
    private Key secretKey;
    private IvParameterSpec ivParam;

    @Override
    public void initKey(String key) {
        byte[] keyData = Base64Util.base64ToByte(key);
        this.ivParam = new IvParameterSpec(keyData, 0, 16);
        this.secretKey = new SecretKeySpec(keyData, 16, keyData.length - 16, ALGORITHM);
    }

    @Override
    public byte[] internalEncrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, this.secretKey, this.ivParam);
        return cipher.doFinal(data);
    }

    @Override
    public byte[] internalDecrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, this.secretKey, this.ivParam);
        return cipher.doFinal(data);
    }
}

