/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.codec;

import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.niolex.commons.internal.IgnoreException;
import org.apache.niolex.commons.test.Check;

public abstract class StringUtil
extends StringUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset GBK = IgnoreException.getCharset("gbk");
    public static final Charset ISO8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset UTF_16 = Charset.forName("UTF-16");

    public static final String utf8ByteToStr(byte[] data) {
        return new String(data, UTF_8);
    }

    public static final byte[] strToUtf8Byte(String str) {
        return str.getBytes(UTF_8);
    }

    public static final String asciiByteToStr(byte[] data) {
        return new String(data, US_ASCII);
    }

    public static final byte[] strToAsciiByte(String str) {
        return str.getBytes(US_ASCII);
    }

    public static final String gbkByteToStr(byte[] data) {
        return new String(data, GBK);
    }

    public static final byte[] strToGbkByte(String str) {
        return str.getBytes(GBK);
    }

    public static final String join(String sep, String ... strs) {
        return StringUtil.join(strs, sep);
    }

    public static final String concat(String sep, String ... arr) {
        return StringUtil.join(arr, sep);
    }

    public static final String join(String[] strs, String sep) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(strs[0]);
        for (int i = 1; i < strs.length; ++i) {
            sb.append(sep).append(strs[i]);
        }
        return sb.toString();
    }

    public static final String join(String sep, Collection<String> strs) {
        return StringUtil.concat(strs, sep);
    }

    public static final String concat(Collection<String> strs, String sep) {
        if (strs == null || strs.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = strs.iterator();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(sep).append(it.next());
        }
        return sb.toString();
    }

    public static final String[] split(String str, String separator, boolean preserveEmptyToken) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int i = 0;
        int len = separator.length();
        int total = str.length();
        while ((i = str.indexOf(separator, start)) != -1) {
            if (start != i || preserveEmptyToken) {
                list.add(str.substring(start, i));
            }
            start = i + len;
        }
        if (start != total || preserveEmptyToken) {
            list.add(str.substring(start, total));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] splitLines(String str, boolean preserveEmptyLines) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return new String[]{str};
        }
        int len = str.length();
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\r') {
                if (start != i || preserveEmptyLines) {
                    list.add(str.substring(start, i));
                }
                if (i + 1 < len && str.charAt(i + 1) == '\n') {
                    ++i;
                }
                start = i + 1;
                continue;
            }
            if (ch != '\n') continue;
            if (start != i || preserveEmptyLines) {
                list.add(str.substring(start, i));
            }
            start = i + 1;
        }
        if (start != len) {
            list.add(str.substring(start, len));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final boolean isIn(String target, String ... args) {
        return StringUtil.isIn(target, true, args);
    }

    public static final boolean isIn(String target, boolean caseSensitive, String ... args) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            return false;
        }
        for (String s : args) {
            if (!(caseSensitive ? target.equals(s) : target.equalsIgnoreCase(s))) continue;
            return true;
        }
        return false;
    }

    public static final List<String> retrieve(String str, char left, char right) {
        ArrayList list = Lists.newArrayList();
        boolean stat = false;
        int idx = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == left) {
                stat = true;
                idx = i + 1;
                continue;
            }
            if (!stat || str.charAt(i) != right) continue;
            stat = false;
            list.add(str.substring(idx, i));
        }
        return list;
    }

    public static final List<String> retrieve(String str, String left, String right) {
        int l;
        if (left.length() == 1 && right.length() == 1) {
            return StringUtil.retrieve(str, left.charAt(0), right.charAt(0));
        }
        ArrayList list = Lists.newArrayList();
        int r = 0;
        int ll = left.length();
        int rl = right.length();
        while ((l = str.indexOf(left, r) + ll) >= ll && (r = str.indexOf(right, l)) >= 0) {
            l = str.lastIndexOf(left, r - ll) + ll;
            list.add(str.substring(l, r));
            r += rl;
        }
        return list;
    }

    public static final String trim(String str, char c) {
        return StringUtil.trim(str, c, TrimMode.BOTH);
    }

    public static final String trim(String str, char c, TrimMode m) {
        int s;
        Check.notNull((Object)str, (String)"<str> can not be null", (Object[])new Object[0]);
        int e = str.length();
        if (m == TrimMode.BOTH || m == TrimMode.LEFT) {
            for (s = 0; s < e && str.charAt(s) == c; ++s) {
            }
        }
        if (m == TrimMode.BOTH || m == TrimMode.RIGHT) {
            while (s < e && str.charAt(e - 1) == c) {
                --e;
            }
        }
        if (s < e) {
            return str.substring(s, e);
        }
        return "";
    }

    public static final String[] toArray(String ... arr) {
        return arr;
    }

    public static enum TrimMode {
        LEFT,
        RIGHT,
        BOTH;

    }
}

