/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.codec;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.apache.niolex.commons.codec.StringUtil;

public abstract class CipherUtil {
    public static MessageDigest getInstance(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The runtime doesn't support the algorithm: " + name, e);
        }
    }

    public static MessageDigest digest(MessageDigest md, String[] plainTexts) {
        int size = plainTexts.length;
        for (int i = 0; i < size; ++i) {
            String plainText = plainTexts[i];
            if (plainText == null) {
                md.update((byte)-40);
            } else {
                md.update(StringUtil.strToUtf8Byte(plainText));
            }
            if (i == size - 1) continue;
            md.update((byte)-19);
        }
        return md;
    }

    public static byte[] process(Cipher cipher, int blockSize, byte[] input) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (input.length <= blockSize) {
            return cipher.doFinal(input);
        }
        int OUTPUT_SIZE = (input.length + blockSize - 1) / blockSize * cipher.getOutputSize(blockSize);
        byte[] output = new byte[OUTPUT_SIZE];
        int outputIndex = 0;
        int i = 0;
        while (true) {
            if (i + blockSize < input.length) {
                outputIndex += cipher.doFinal(input, i, blockSize, output, outputIndex);
            } else {
                outputIndex += cipher.doFinal(input, i, input.length - i, output, outputIndex);
                break;
            }
            i += blockSize;
        }
        if (outputIndex != OUTPUT_SIZE) {
            return Arrays.copyOfRange(output, 0, outputIndex);
        }
        return output;
    }
}

