/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.codec;

import java.util.Arrays;

public abstract class Base16Util {
    private static final char[] DIGIT_TO_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte[] CHAR_TO_DIGIT = new byte[128];

    public static final String byteToBase16(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("The parameter should not be null!");
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(DIGIT_TO_CHAR[(b & 0xF0) >>> 4]);
            sb.append(DIGIT_TO_CHAR[b & 0xF]);
        }
        return sb.toString();
    }

    public static final byte[] base16ToByte(String str) {
        if (str == null) {
            throw new IllegalArgumentException("The parameter should not be null!");
        }
        char[] hex = str.toLowerCase().toCharArray();
        int hexLen = str.length();
        if (hexLen % 2 != 0) {
            throw new IllegalArgumentException("The parameter length should be even!");
        }
        byte[] bytes = new byte[hexLen / 2];
        int i = 0;
        int j = 0;
        while (i < hexLen) {
            if (hex[i] > '\u0080' || hex[i + 1] > '\u0080') {
                throw new IllegalArgumentException("The parameter contains invalid charater!");
            }
            if (CHAR_TO_DIGIT[hex[i]] < 0 || CHAR_TO_DIGIT[hex[i + 1]] < 0) {
                throw new IllegalArgumentException("The parameter contains invalid charater!");
            }
            bytes[j] = (byte)(CHAR_TO_DIGIT[hex[i]] << 4 | CHAR_TO_DIGIT[hex[i + 1]]);
            i += 2;
            ++j;
        }
        return bytes;
    }

    static {
        Arrays.fill(CHAR_TO_DIGIT, (byte)-1);
        Base16Util.CHAR_TO_DIGIT[48] = 0;
        Base16Util.CHAR_TO_DIGIT[49] = 1;
        Base16Util.CHAR_TO_DIGIT[50] = 2;
        Base16Util.CHAR_TO_DIGIT[51] = 3;
        Base16Util.CHAR_TO_DIGIT[52] = 4;
        Base16Util.CHAR_TO_DIGIT[53] = 5;
        Base16Util.CHAR_TO_DIGIT[54] = 6;
        Base16Util.CHAR_TO_DIGIT[55] = 7;
        Base16Util.CHAR_TO_DIGIT[56] = 8;
        Base16Util.CHAR_TO_DIGIT[57] = 9;
        Base16Util.CHAR_TO_DIGIT[97] = 10;
        Base16Util.CHAR_TO_DIGIT[98] = 11;
        Base16Util.CHAR_TO_DIGIT[99] = 12;
        Base16Util.CHAR_TO_DIGIT[100] = 13;
        Base16Util.CHAR_TO_DIGIT[101] = 14;
        Base16Util.CHAR_TO_DIGIT[102] = 15;
    }
}

